/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.easyexcel;

import cn.smarthse.rho.modules.company.service.e.manage.IEMachineRoomManageService;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.MachineRoomImportDto;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.CellExtra;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineRoomImportListener
extends AnalysisEventListener<MachineRoomImportDto> {
    private static final Logger log = LoggerFactory.getLogger(MachineRoomImportListener.class);
    private static final int BATCH_COUNT = 3000;
    List<MachineRoomImportDto> list = new ArrayList<MachineRoomImportDto>();
    private final IEMachineRoomManageService service;

    public MachineRoomImportListener(IEMachineRoomManageService service) {
        this.service = service;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        super.onException(exception, context);
    }

    public void invoke(MachineRoomImportDto data, AnalysisContext context) {
        this.list.add(data);
        if (this.list.size() >= 3000) {
            this.saveData();
            this.list.clear();
        }
    }

    private void saveData() {
        log.debug("\u5bfc\u5165\u673a\u623f - {}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.list.size());
        this.service.importMachineRoom(this.list);
        log.debug("\u5bfc\u5165\u673a\u623f - \u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    public void extra(CellExtra extra, AnalysisContext context) {
        super.extra(extra, context);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.debug("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
        this.saveData();
    }

    public boolean hasNext(AnalysisContext context) {
        return super.hasNext(context);
    }
}

