/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.sys;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserAddForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForComParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForComVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForComVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1701, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u6a21\u5757\uff1a\u8d26\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/companyUser"})
@Validated
public class SysCompanyUserController
extends ControllerSupport {
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<SysUserCompanyListForComVo>> getList(@Validated SysCompanyUserListParam param) {
        return ResponseData.success((Object)this.sysUserServiceProvider.getSysCompanyUserListForCom(param));
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/getOne/{userId}"})
    public ResponseData<SysUserCompanyOneForComVo> getOne(@PathVariable Long userId) {
        return ResponseData.success((Object)this.sysUserServiceProvider.getSysUserCompanyByUserIdForCom(userId));
    }

    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_sys_user)
    @ApiOperation(value="\u65b0\u589e")
    @PutMapping(value={"/save"})
    public ResponseData<String> save(@RequestBody @Validated SysCompanyUserAddForComParam param) {
        return this.sysUserServiceProvider.addUserForCom(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_sys_user)
    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/updateResource"})
    public ResponseData<String> updateResource(@RequestBody @Validated SysCompanyUserEditForComParam param) {
        return this.sysUserServiceProvider.updateSysCompanyUserEditForCom(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_sys_user, title="\u7981\u7528\u3001\u542f\u7528")
    @ApiOperation(value="\u72b6\u6001")
    @PutMapping(value={"/updateSysCompanyStatue"})
    public ResponseData<String> updateSysCompanyStatue(@RequestBody @Validated SysCompanyUserStatueEditForComParam param) {
        return this.sysUserServiceProvider.updateSysCompanyUserStatueForCom(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_reset, logModule=LogModuleTypeEnum.com_sys_user)
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @PutMapping(value={"/resetPassword"})
    public ResponseData<String> resetPassword(@RequestBody @Validated IdParam param) {
        return this.sysUserServiceProvider.resetPasswordForCom(param) != false ? ResponseData.success((Object)"Zyj@2022") : ResponseData.fail();
    }

    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_sys_user)
    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteResource"})
    public ResponseData<String> deleteSysCompanyUser(@RequestBody @Validated IdParam param) {
        return this.sysUserServiceProvider.deleteSysCompanyUserByUserIdForCom(param) != false ? ResponseData.success() : ResponseData.fail();
    }
}

