/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.risk;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.model.r.param.RiskAcceptRecordSubmitParam;
import cn.smarthse.rho.modules.company.model.r.param.RiskQueryParam;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailAcceptRecordVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailSourceVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailStatisticDataVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionStatisticsVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskSourceHistoryVo;
import cn.smarthse.rho.modules.company.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u98ce\u9669\u5316\u89e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/riskResolution"})
public class RiskResolutionController {
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskBasicSourceService sourceService;
    @Autowired
    private IRRiskAcceptanceRecordService acceptanceRecordService;

    @ApiOperation(value="\u98ce\u9669\u5316\u89e3\u7ba1\u7406-\u7edf\u8ba1")
    @GetMapping(value={"/getRiskResolutionStatisticsData"})
    public ResponseData<RiskResolutionStatisticsVo> getRiskResolutionStatisticsData() {
        return ResponseData.success((Object)this.riskBasicService.getRiskResolutionStatisticsData(ShiroUtil.getLoginUserCid()));
    }

    @ApiOperation(value="\u98ce\u9669\u5316\u89e3\u7ba1\u7406-\u5217\u8868")
    @GetMapping(value={"/getRiskListData"})
    public ResponseData<LayuiGridData<RiskResolutionListItemVo>> getRiskListData(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.riskBasicService.getRiskListData(param));
    }

    @ApiOperation(value="\u98ce\u9669\u5316\u89e3\u7ba1\u7406\u8be6\u60c5\uff08\u5de6\u8fb9\u98ce\u9669\u5207\u6362\uff09-\u98ce\u9669")
    @GetMapping(value={"/getRiskDetailListData"})
    public ResponseData<List<RiskDetailListItemVo>> getRiskDetailListData(Long riskId, Integer riskType) {
        return ResponseData.success(this.riskBasicService.getRiskDetailListData(riskId, riskType));
    }

    @ApiOperation(value="\u8bb8\u53ef-\u98ce\u9669\u5316\u89e3\u7ba1\u7406\u8be6\u60c5\uff08\u53f3\u8fb9\uff09-\u6574\u6539\u9a8c\u6536\u8bb0\u5f55")
    @GetMapping(value={"/getRiskDetailAcceptRecordListData"})
    public ResponseData<List<RiskDetailAcceptRecordVo>> getRiskDetailAcceptRecordListData(Long riskId) {
        return ResponseData.success(this.acceptanceRecordService.getRiskDetailAcceptRecordListData(riskId));
    }

    @ApiOperation(value="\u8bb8\u53ef-\u6574\u6539\u5b58\u8349\u7a3f")
    @PostMapping(value={"/rectificationDraftSave"})
    public ResponseData<String> rectificationDraftSave(@RequestBody @Validated RiskAcceptRecordSubmitParam param) {
        this.acceptanceRecordService.rectificationDraftSave(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u8bb8\u53ef-\u6574\u6539\u63d0\u4ea4")
    @PostMapping(value={"/rectificationSubmit"})
    public ResponseData<String> rectificationSubmit(@RequestBody @Validated RiskAcceptRecordSubmitParam param) {
        this.acceptanceRecordService.acceptRecordSubmit(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u8be6\u60c5-\u98ce\u9669\u7edf\u8ba1\u6570\u636e(\u9876\u90e82)")
    @GetMapping(value={"/getRiskStatisticData"})
    public ResponseData<RiskDetailStatisticDataVo> getRiskStatisticData(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.riskBasicService.getRiskStatisticData(param));
    }

    @ApiOperation(value="\u8be6\u60c5-source\u98ce\u9669\u5217\u8868(\u5e95\u90e8)")
    @GetMapping(value={"/listSourceByRiskId"})
    public ResponseData<LayuiGridData<RiskDetailSourceVo>> listSourceByRiskId(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.riskBasicService.listSourceByRiskId(param));
    }

    @ApiOperation(value="\u98ce\u9669\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55")
    @GetMapping(value={"/listSourceHistory"})
    public ResponseData<LayuiGridData<RiskSourceHistoryVo>> listSourceHistory(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.sourceService.listSourceHistory(param));
    }
}

