/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.g.IGSafetyDevicesWarningSignsService;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactorTypeEnum;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckEditParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckIdParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckStatusLogListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSelfCheckCommitmentEditParam;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckListStatisticsVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckOneVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckStatusLogListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSelfCheckCommitmentVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.smarthse.framework.exception.ServiceException;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/safety/device"})
@Validated
public class GSafetyDevicesWarningSignsController {
    private static final Logger log = LoggerFactory.getLogger(GSafetyDevicesWarningSignsController.class);
    @Autowired
    private IGSafetyDevicesWarningSignsService safetyDevicesWarningSignsService;

    @PostMapping(value={"/editCommitment"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_protective, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u4e2a\u4eba\u9632\u62a4\u7528\u54c1-\u65b0\u589e\u6216\u7f16\u8f91\u81ea\u68c0\u627f\u8bfa")
    public ResponseData<String> addOrEditCommitment(@RequestBody @Validated GSelfCheckCommitmentEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        param.setKeyFactorType(KeyFactorTypeEnum.SD_SELF_CHECK.getCode());
        this.safetyDevicesWarningSignsService.addOrEditCommitment(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getCommitment"})
    public ResponseData<GSelfCheckCommitmentVo> getCommitment() {
        return ResponseData.success((Object)this.safetyDevicesWarningSignsService.getCommitment());
    }

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<GSafetyDeviceSelfCheckListVo>> getList(@Validated GSafetyDeviceSelfCheckListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.safetyDevicesWarningSignsService.getSelfCheckList(param));
    }

    @GetMapping(value={"/getStatistics"})
    public ResponseData<GSafetyDeviceSelfCheckListStatisticsVo> getStatistics(@Validated GSafetyDeviceSelfCheckListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.safetyDevicesWarningSignsService.getStatistics(param));
    }

    @PostMapping(value={"/addSelfCheck"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_keyFactor_safety_device, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6-\u65b0\u589e\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> addSelfCheck(@RequestBody @Validated GSafetyDeviceSelfCheckEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.safetyDevicesWarningSignsService.addOrEditOneSelfCheck(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/editSelfCheck"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_safety_device, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6-\u7f16\u8f91\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> editSelfCheck(@RequestBody @Validated GSafetyDeviceSelfCheckEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.safetyDevicesWarningSignsService.addOrEditOneSelfCheck(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getSelfCheckById/{id}"})
    public ResponseData<GSafetyDeviceSelfCheckOneVo> getSelfCheckById(@PathVariable(value="id") @NotNull(message="\u81ea\u68c0id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u81ea\u68c0id\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        return ResponseData.success((Object)this.safetyDevicesWarningSignsService.getOneById(id));
    }

    @GetMapping(value={"/getStatusLogList"})
    public ResponseData<LayuiGridData<GSafetyDeviceSelfCheckStatusLogListVo>> getStatusLogList(@Validated GSafetyDeviceSelfCheckStatusLogListParam param) {
        return ResponseData.success(this.safetyDevicesWarningSignsService.getStatusLogList(param));
    }

    @PostMapping(value={"/delSelfCheck/{id}"})
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_keyFactor_safety_device, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u5b89\u5168\u548c\u88c5\u7f6e\u4e0e\u8b66\u793a\u6807\u8bc6-\u5220\u9664\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> delSelfCheck(@PathVariable(value="id") @NotNull(message="\u81ea\u68c0id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u81ea\u68c0id\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.safetyDevicesWarningSignsService.delSelfCheck(id);
        return ResponseData.success();
    }

    @PostMapping(value={"/termination"})
    @Log(type=LogTypeEnum.anon, logModule=LogModuleTypeEnum.com_keyFactor_safety_device, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u5b89\u5168\u88c5\u7f6e\u4e0e\u8b66\u793a\u6807\u8bc6-\u4e2d\u6b62\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> termination(@RequestBody @Validated GSafetyDeviceSelfCheckIdParam param) {
        this.safetyDevicesWarningSignsService.termination(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/template/download"})
    public void downloadTemplate(HttpServletResponse response) {
        try (InputStream in = new ClassPathResource("templates/templateDoc.pdf").getInputStream();
             ServletOutputStream out = response.getOutputStream();){
            String fileName = URLEncoder.encode("\u6a21\u677f.pdf", StandardCharsets.UTF_8.toString());
            response.setContentType("application/pdf");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            log.error("PDF\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            try {
                response.reset();
                response.setStatus(500);
                response.setContentType("text/plain;charset=UTF-8");
                response.getWriter().write("PDF\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            catch (IOException ioException) {
                log.error("\u54cd\u5e94\u5931\u8d25\u4fe1\u606f\u5199\u5165\u51fa\u9519", (Throwable)ioException);
            }
            throw new ServiceException("PDF\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25");
        }
    }
}

