/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.FieldCheckUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.f.IFProjectService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectEditParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectDetailQueryParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectQueryParam;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectDetailVo;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysBusinessOperateLogParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u533b\u9662\uff1a\u4e09\u540c\u65f6\u9879\u76ee"})
@RestController
@RequestMapping(value={"/threeProject"})
public class FThreeProjectController {
    @Autowired
    private IFProjectService projectService;
    @Autowired
    private IBCompanyService companyService;
    @DubboReference
    private ISysBusinessOperateLogProvider operateLogProvider;

    @ApiOperation(value="\u4e09\u540c\u65f6\u7ba1\u7406\u9879\u76ee\u5217\u8868")
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<FThreeTimesProjectVo>> getList(ThreeProjectQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.projectService.getThreeProjectList(param));
    }

    @ApiOperation(value="\u4e09\u540c\u65f6\u9879\u76ee\u8be6\u60c5\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/getDetail"})
    public ResponseData<FThreeTimesProjectDetailVo> getDetail(@Validated ThreeProjectDetailQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.projectService.getDetailByProjectId(param));
    }

    @ApiOperation(value="\u4e09\u540c\u65f6\u9879\u76ee\u8be6\u60c5-\u533b\u9662\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/getComBaseInfo"})
    public ResponseData<BCompany> getComBaseInfo(Long id) {
        return ResponseData.success((Object)this.companyService.getById(id));
    }

    @ApiOperation(value="\u4e09\u540c\u65f6\u5b58\u8349\u7a3f")
    @PostMapping(value={"/edit"})
    public ResponseData<String> edit(@RequestBody FThreeTimesProjectEditParam param) {
        if (param.getBaseInfo() == null) {
            return ResponseData.fail((String)"\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u7f3a\u5931\uff01");
        }
        this.projectService.editThreeTimesProject(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4e09\u540c\u65f6\u63d0\u4ea4\uff08\u524d\u7aef\u6821\u9a8c\u6240\u6709\u9879\u76ee\u5747\u5df2\u5b8c\u6210\u586b\u5199\uff09")
    @PostMapping(value={"/submit"})
    public ResponseData<String> submit(@RequestBody @Validated FThreeTimesProjectEditParam param) {
        if (param.getBaseInfo() == null) {
            return ResponseData.fail((String)"\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u7f3a\u5931\uff01");
        }
        FieldCheckUtils.checkEmptyFields((Object)param.getBaseInfo(), (String[])new String[]{"name|\u9879\u76ee\u540d\u79f0", "projectType|\u9879\u76ee\u6027\u8d28", "raType|\u9879\u76ee\u7c7b\u578b", "occType|\u804c\u4e1a\u75c5\u5371\u5bb3\u7c7b\u522b", "beginDate|\u7acb\u9879\u65f6\u95f4", "finishDate|\u7ae3\u5de5\u65f6\u95f4"});
        FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail1(), (String[])new String[]{"fillType|\u573a\u6240\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "preTechName|\u9884\u8bc4\u6280\u672f\u670d\u52a1\u673a\u6784\u540d\u79f0", "preReportNo|\u9884\u8bc4\u4ef7\u62a5\u544a\u4e66\u7f16\u53f7", "preReportDate|\u9884\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4", "cvaTechName|\u63a7\u8bc4\u6280\u672f\u670d\u52a1\u673a\u6784\u540d\u79f0", "cvaReportNo|\u63a7\u8bc4\u62a5\u544a\u4e66\u7f16\u53f7", "cvaReportDate|\u63a7\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4", "checkReportNo|\u573a\u6240\u68c0\u6d4b\u62a5\u544a"});
        if (param.getProjectDetail2() != null && param.getProjectDetail2().getFillType() == 1) {
            FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail2(), (String[])new String[]{"fillType|\u573a\u6240\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "preTechName|\u9884\u8bc4\u6280\u672f\u670d\u52a1\u673a\u6784\u540d\u79f0", "preReportNo|\u9884\u8bc4\u4ef7\u62a5\u544a\u4e66\u7f16\u53f7", "preReportDate|\u9884\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4", "cvaTechName|\u63a7\u8bc4\u6280\u672f\u670d\u52a1\u673a\u6784\u540d\u79f0", "cvaReportNo|\u63a7\u8bc4\u62a5\u544a\u4e66\u7f16\u53f7", "cvaReportDate|\u63a7\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4", "checkReportNo|\u573a\u6240\u68c0\u6d4b\u62a5\u544a"});
        } else {
            FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail2(), (String[])new String[]{"fillType|\u573a\u6240\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "reason|\u5408\u7406\u7f3a\u9879\u539f\u56e0"});
        }
        this.projectService.submitThreeTimesProject(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u64cd\u4f5c\u8bb0\u5f55\u5217\u8868")
    @GetMapping(value={"/getOperateLogListData"})
    public ResponseData<LayuiGridData<SysBusinessOperateLog>> getOperateLogListData(SysBusinessOperateLogParam param) {
        return ResponseData.success((Object)this.operateLogProvider.getPageListData(param));
    }
}

