/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCertChooseListParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingRelationshipParam;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffCertChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.provider.c.ITrainingCertProvider;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u653e\u5c04\u536b\u751f\u57f9\u8bad"})
@RestController
@RequestMapping(value={"/trainingCert"})
public class CTrainingCertController
extends ControllerSupport {
    @Autowired
    private ICTrainingCertService trainingCertService;
    @Autowired
    private ICStaffBaseInfoService cStaffBaseInfoService;
    @DubboReference(registry={"local_nacos"})
    private ITrainingCertProvider trainingCertProvider;

    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u57f9\u8bad\u8bc1\u4e66\u5217\u8868")
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<CTrainingCert>> getList(CTrainingCertPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.trainingCertService.getListForKeyFactor(param));
    }

    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u57f9\u8bad\u8bc1\u4e66\u8be6\u60c5")
    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<CTrainingCert> getTrainingCertDetail(IdParam idParam) {
        return ResponseData.success((Object)this.trainingCertService.getTrainingCertDetailById(idParam.getId()));
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u9009\u62e9\u5217\u8868")
    @GetMapping(value={"/getChooseList"})
    public ResponseData<LayuiGridData<StaffChooseListVo>> getChooseList(StaffCmPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffBaseInfoService.getChooseList(param));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u7f16\u8f91\u8bc1\u4e66\uff08\u753b\u50cf\u5ba1\u6838\u63d0\u4ea4\uff09")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_train, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u653e\u5c04\u536b\u751f\u57f9\u8bad-\u65b0\u589e\u6216\u7f16\u8f91\u8bc1\u4e66\uff08\u753b\u50cf\u5ba1\u6838\u63d0\u4ea4\uff09")
    @PostMapping(value={"/edit"})
    public ResponseData<String> addOrEditCert(@RequestBody @Validated TrainingCertEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.trainingCertService.addOrEditCert(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u8bc1\u4e66\u5173\u8054\u4eba\u5458")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_train, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u653e\u5c04\u536b\u751f\u57f9\u8bad-\u8bc1\u4e66\u5173\u8054\u4eba\u5458")
    @PostMapping(value={"/addRelatedRelationships"})
    public ResponseData<String> addRelatedRelationships(@RequestBody TrainingRelationshipParam param) {
        this.trainingCertProvider.addRelatedRelationships(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4eba\u5458\u7ed1\u5b9a\u8bc1\u4e66\u7684\u8bc1\u4e66\u9009\u62e9\u5217\u8868")
    @GetMapping(value={"/getStaffCertChooseList"})
    public ResponseData<LayuiGridData<StaffCertChooseListVo>> getStaffCertChooseList(StaffCertChooseListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.trainingCertProvider.getStaffCertChooseList(param));
    }

    @ApiOperation(value="\u7ec8\u6b62\u7533\u8bf7")
    @PostMapping(value={"/suspend"})
    public ResponseData<String> suspend(@RequestBody IdParam param) {
        this.trainingCertService.suspendApplication(param.getId());
        return ResponseData.success();
    }

    @ApiOperation(value="\u8349\u7a3f\u5220\u9664")
    @PostMapping(value={"/del"})
    public ResponseData<String> del(@RequestBody IdParam param) {
        this.trainingCertService.delById(param.getId());
        return ResponseData.success();
    }
}

