/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.model.c.BigDoseStatisticsVo;
import cn.smarthse.rho.modules.company.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.company.service.c.ICDoseService;
import cn.smarthse.rho.modules.sys.entity.c.CDose;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b"})
@RestController
@RequestMapping(value={"/dose"})
public class CDoseController {
    @Autowired
    private ICDoseService doseService;
    @Autowired
    private ICDoseDataService doseDataService;

    @ApiOperation(value="\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u5217\u8868")
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<CDose>> getList(CDoseQueryParam param) {
        return ResponseData.success(this.doseService.getMonitorList(param));
    }

    @ApiOperation(value="\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u8be6\u60c5")
    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<CDose> getCheckDetail(Long baseId) {
        return ResponseData.success((Object)this.doseService.getMonitorDetail(baseId));
    }

    @ApiOperation(value="\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u8be6\u60c5\u7f16\u8f91")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_dose_monitor, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b-\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u8be6\u60c5\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public ResponseData<String> edit(CDoseData param) {
        this.doseDataService.updateById(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u4e2a\u4eba\u5242\u91cf\u76d1\u6d4b\u8be6\u60c5\u5217\u8868")
    @GetMapping(value={"/getResultList"})
    public ResponseData<LayuiGridData<CDoseData>> getResultList(CDoseQueryParam param) {
        return ResponseData.success(this.doseDataService.getDoseDataList(param));
    }

    @ApiOperation(value="\u8fc7\u91cf\u7167\u5c04\u7edf\u8ba1")
    @GetMapping(value={"/getBigDoseStatisticsData"})
    public ResponseData<BigDoseStatisticsVo> getBigDoseStatisticsData() {
        return ResponseData.success((Object)this.doseDataService.getBigDoseStatisticsData(ShiroUtil.getLoginUserCid()));
    }

    @ApiOperation(value="\u8fc7\u91cf\u7167\u5c04\u8c03\u67e5\u5217\u8868")
    @GetMapping(value={"/getOverDoseList"})
    public ResponseData<LayuiGridData<CDoseData>> getOverDoseList(CDoseQueryParam param) {
        return ResponseData.success(this.doseDataService.getOverDoseDataList(param));
    }
}

