/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.company.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyCampusVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffInfoRangeParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffWorkExperiencePageParam;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.CertStaffChooseListParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffAcInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChangeLogParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffSelectInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffStatisticsParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CStaffWorkExperienceVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CertStaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CompanyStaffArchiveStatisticsVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffAcVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsCMVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChangeLogVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffSelectInfo;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/staff"})
public class StaffInfoController
extends ControllerSupport {
    private final ICStaffBaseInfoService cStaffBaseInfoService;
    private final ICStaffService cStaffService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICDoseDataService doseDataService;
    private final ICStaffWorkExperienceService cStaffWorkExperienceService;
    private final ICTrainingCertService cTrainingCertService;
    private final IBCompanyService companyService;
    @DubboReference(registry={"local_nacos"})
    private IStaffProvider staffProvider;

    @GetMapping(value={"/getStaffArchiveList"})
    public ResponseData<LayuiGridData<StaffArchiveListVo>> getStaffArchiveList(StaffCmPageParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getCidList())) {
            StaffCmPageParam cmListParam = new StaffCmPageParam();
            cmListParam.setCid(ShiroUtil.getLoginUserCid());
            cmListParam.setLimit(1000);
            List<BCompanyCampusVo> cmList = this.companyService.getBranchListForStaffArchive(ShiroUtil.getLoginUserCid());
            if (CollectionUtil.isNotEmpty(cmList)) {
                List cidList = cmList.stream().map(v -> v.getId()).collect(Collectors.toList());
                param.setCidList(cidList);
            }
        }
        LayuiGridData<StaffArchiveListVo> result = this.cStaffBaseInfoService.getStaffArchiveList(param);
        for (StaffArchiveListVo vo : result.getData()) {
            vo.genSex();
            vo.genAge();
            vo.genPhone();
            vo.genIdcard();
        }
        return ResponseData.success(result);
    }

    @GetMapping(value={"/getCertStaffChooseList"})
    public ResponseData<LayuiGridData<CertStaffChooseListVo>> getCertStaffChooseList(CertStaffChooseListParam param) {
        return new ResponseData((Object)this.staffProvider.getCertStaffChooseList(param));
    }

    @GetMapping(value={"/getPostStaffArchiveList"})
    public ResponseData<LayuiGridData<StaffArchiveListVo>> getPostStaffArchiveList(StaffCmPageParam param) {
        LayuiGridData<StaffArchiveListVo> result = this.cStaffBaseInfoService.getPostStaffArchiveList(param);
        for (StaffArchiveListVo vo : result.getData()) {
            vo.genSex();
            vo.genAge();
            vo.genPhone();
            vo.genIdcard();
        }
        return ResponseData.success(result);
    }

    @GetMapping(value={"/getChooseList"})
    public ResponseData<LayuiGridData<StaffChooseListVo>> getChooseList(StaffCmPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffBaseInfoService.getChooseList(param));
    }

    @PostMapping(value={"/edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u7f16\u8f91")
    public ResponseData edit(@RequestBody CStaffBaseInfoEditParam param) {
        if (param.getStaffEditParam() != null && param.getStaffEditParam().getCid() != null && !this.companyService.isSameHospital(param.getStaffEditParam().getCid(), ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.staffProvider.editStaffFullInfo(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/add"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u65b0\u589e")
    public ResponseData add(@RequestBody CStaffBaseInfoEditParam param) {
        if (param.getStaffEditParam() != null && !this.companyService.isSameHospital(param.getStaffEditParam().getCid(), ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        param.setSource(StaffSourceEnum.UNIT.getValue());
        if (param.getStaffEditParam() != null) {
            param.getStaffEditParam().setSource(StaffSourceEnum.UNIT.getValue());
        }
        this.staffProvider.addStaffFullInfo(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u65b0\u589e\u7ba1\u7406\u5458")
    @PostMapping(value={"/add/manager"})
    public ResponseData addManager(@RequestBody CStaffBaseInfoEditParam param) {
        CStaffEditParam staffEditParam = param.getStaffEditParam();
        if (staffEditParam != null && !ShiroUtil.getLoginUserCid().equals(param.getStaffEditParam().getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        if (staffEditParam != null && !this.companyService.isSameHospital(staffEditParam.getCid(), ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u516c\u53f8\u4fe1\u606f\u4e0d\u660e\u786e\uff0c\u53ef\u5237\u65b0\u540e\u518d\u6b21\u7f16\u8f91");
        }
        this.staffProvider.addManager(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u5220\u9664")
    @PostMapping(value={"/delete"})
    public ResponseData delete(@RequestBody CStaffBaseInfoEditParam param) {
        if (param.getStaffEditParam() != null && !this.companyService.isSameHospital(param.getStaffEditParam().getCid(), ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.cStaffBaseInfoService.delete(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getBaseInfo"})
    public ResponseData<StaffArchiveListVo> getBaseInfo(StaffInfoParam param) {
        param.setCid(this.cStaffBaseInfoService.getStaffCid(param.getId(), ShiroUtil.getLoginUserCid()));
        if (param.getCid() == null) {
            throw new ServiceException("\u8be5\u4eba\u5458\u975e\u672c\u533b\u9662\u5458\u5de5\uff0c\u65e0\u6cd5\u67e5\u770b");
        }
        StaffArchiveListVo result = this.cStaffBaseInfoService.getInfo(param);
        result.genSex();
        result.genAge();
        result.genIdcard();
        if (param.getAcInfoModel() == null || param.getAcInfoModel() == 0) {
            result.genPhone();
        }
        return ResponseData.success((Object)result);
    }

    @GetMapping(value={"/getBaseInfo/rayManager"})
    public ResponseData<StaffArchiveListVo> getRayManagerInfo(StaffInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        StaffArchiveListVo result = this.cStaffBaseInfoService.getRayManagerInfo(param);
        result.genSex();
        result.genAge();
        result.genPhone();
        result.genIdcard();
        return ResponseData.success((Object)result);
    }

    @GetMapping(value={"/getSelectInfo"})
    @Log(type=LogTypeEnum.anon, logModule=LogModuleTypeEnum.com_base_staff, title="\u9009\u62e9\u4eba\u5458\u4fe1\u606f\uff08\u5355\u4e2a\uff09")
    public ResponseData<StaffSelectInfo> getSelectInfoForAdding(StaffSelectInfoParam param) {
        return ResponseData.success((Object)this.staffProvider.getSelectInfoForAdding(param));
    }

    @GetMapping(value={"/getAcInfo"})
    @Log(type=LogTypeEnum.anon, logModule=LogModuleTypeEnum.com_base_staff, title="\u83b7\u53d6\u4eba\u5458\u91cd\u8981\u4fe1\u606f")
    public ResponseData<StaffAcVo> getAcInfo(StaffAcInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.cStaffBaseInfoService.getAcInfo(param));
    }

    @GetMapping(value={"/getStaffArchiveStatistics"})
    public ResponseData<StaffArchiveStatisticsCMVo> getStaffArchiveStatistics(StaffStatisticsParam param) {
        param.setCid(this.cStaffBaseInfoService.getStaffCid(param.getId(), ShiroUtil.getLoginUserCid()));
        if (param.getCid() == null) {
            throw new ServiceException("\u8be5\u4eba\u5458\u975e\u672c\u533b\u9662\u5458\u5de5\uff0c\u65e0\u6cd5\u67e5\u770b");
        }
        return ResponseData.success((Object)this.cStaffBaseInfoService.getStaffArchiveStatistics(param));
    }

    @GetMapping(value={"/getCMStaffArchiveStatistics"})
    public ResponseData<CompanyStaffArchiveStatisticsVo> getCMStaffArchiveStatistics(StaffStatisticsParam param) {
        param.setCid(ShiroUtil.getLoginUserOriginalCid());
        return ResponseData.success((Object)this.cStaffBaseInfoService.getCMStaffArchiveStatistics(param));
    }

    @GetMapping(value={"/getCertCondition"})
    public ResponseData<CertConditionVo> getCertCondition(Long staffBaseInfoId) {
        List<CertConditionVo> certConditionVoList = this.cStaffBaseInfoService.getCertCondition(CollectionUtil.toList((Object[])new Long[]{staffBaseInfoId}));
        return ResponseData.success(CollectionUtil.isEmpty(certConditionVoList) ? null : certConditionVoList.get(0));
    }

    @GetMapping(value={"/getList/health"})
    public ResponseData<LayuiGridData<CHealthCheckData>> getHealthList(CHealthCheckQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForCompany(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setCid(param.getCid()));
        if (rangeVo == null) {
            throw new ServiceException("\u6570\u636e\u8303\u56f4\u5224\u65ad\u5f02\u5e38");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.healthCheckDataService.getListForArchive(param));
    }

    @GetMapping(value={"/getList/dose"})
    public ResponseData<LayuiGridData<CDoseData>> getDoseList(CDoseQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForCompany(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setCid(param.getCid()));
        if (rangeVo == null) {
            throw new ServiceException("\u6570\u636e\u8303\u56f4\u5224\u65ad\u5f02\u5e38");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.doseDataService.getDoseListForArchive(param));
    }

    @GetMapping(value={"/getList/workExperience"})
    public ResponseData<LayuiGridData<CStaffWorkExperienceVo>> getWorkExperienceList(CStaffWorkExperiencePageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffWorkExperienceService.getListForArchive(param));
    }

    @GetMapping(value={"/getList/getCertList"})
    public ResponseData<LayuiGridData<CTrainingCert>> getCertList(CTrainingCertPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForCompany(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setCid(param.getCid()));
        if (rangeVo == null) {
            throw new ServiceException("\u6570\u636e\u8303\u56f4\u5224\u65ad\u5f02\u5e38");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.cTrainingCertService.getListForArchive(param));
    }

    @GetMapping(value={"/staffChangeLoge"})
    public ResponseData<LayuiGridData<StaffChangeLogVo>> getStaffChangeLog(StaffChangeLogParam param) {
        if (StrUtil.isEmpty((CharSequence)param.getFieldValuesStr())) {
            String fieldValues = "name,phone,idcard,sex,age,birthday,head_id,ra_type,base_id,cid,org_id,work_no,post,post_status,if_ra_manager,staff_type";
            param.setFieldValuesStr(fieldValues);
        }
        LayuiGridData staffChangeLog = this.staffProvider.getStaffChangeLog(param);
        return ResponseData.success((Object)staffChangeLog);
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u5355\u4f4d\u4fe1\u606f\u7f16\u8f91")
    @PostMapping(value={"/edit/company"})
    public ResponseData editCompanyInfo(@RequestBody CStaffEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.cStaffService.editInfo(param);
        return ResponseData.success();
    }

    public StaffInfoController(ICStaffBaseInfoService cStaffBaseInfoService, ICStaffService cStaffService, ICHealthCheckDataService healthCheckDataService, ICDoseDataService doseDataService, ICStaffWorkExperienceService cStaffWorkExperienceService, ICTrainingCertService cTrainingCertService, IBCompanyService companyService) {
        this.cStaffBaseInfoService = cStaffBaseInfoService;
        this.cStaffService = cStaffService;
        this.healthCheckDataService = healthCheckDataService;
        this.doseDataService = doseDataService;
        this.cStaffWorkExperienceService = cStaffWorkExperienceService;
        this.cTrainingCertService = cTrainingCertService;
        this.companyService = companyService;
    }
}

