/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBRayManageService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.RayStaffQueryParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BRayManageVo;
import cn.smarthse.rho.modules.sys.model.c.vo.RayStaffListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u9662\uff1a\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4"})
@RequestMapping(value={"/rayGroup"})
public class RayGroupManageController {
    private final IBRayManageService bRayManageService;
    private final ICStaffBaseInfoService cStaffBaseInfoService;

    @ApiOperation(value="\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/getInfo"})
    public ResponseData<BRayManageVo> getInfo(BRayManageInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.bRayManageService.getInfo(param));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/addInfo"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_ray_manage, title="\u533b\u9662\uff1a\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4-\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f")
    public ResponseData<BRayManageVo> addInfo(@RequestBody BRayManageEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        return ResponseData.success((Object)this.bRayManageService.add(param));
    }

    @ApiOperation(value="\u7f16\u8f91")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_ray_manage, title="\u533b\u9662\uff1a\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4-\u7f16\u8f91")
    @PostMapping(value={"/editInfo"})
    public ResponseData<BRayManageVo> editInfo(@RequestBody BRayManageEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        return ResponseData.success((Object)this.bRayManageService.edit(param));
    }

    @ApiOperation(value="\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"/staffList"})
    public ResponseData<LayuiGridData<RayStaffListVo>> rayStaffList(RayStaffQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffBaseInfoService.rayStaffList(param));
    }

    public RayGroupManageController(IBRayManageService bRayManageService, ICStaffBaseInfoService cStaffBaseInfoService) {
        this.bRayManageService = bRayManageService;
        this.cStaffBaseInfoService = cStaffBaseInfoService;
    }
}

