/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.model.b.param.BPostEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.PostInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.PostQueryParam;
import cn.smarthse.rho.modules.sys.provider.company.IPostProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=12, author="xxx")
@Api(tags={"\u5c97\u4f4d\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/post"})
public class PostInfoController {
    @DubboReference
    private IPostProvider postProvider;

    @ApiOperation(value="\u5c97\u4f4d\u5217\u8868")
    @GetMapping(value={"/getPage"})
    public ResponseData<LayuiGridData<BPostVo>> getPostPage(PostQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.postProvider.getPage(param));
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/getInfo"})
    public ResponseData<BPostVo> getPostInfo(PostInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.postProvider.getPostInfo(param));
    }

    @ApiOperation(value="\u5c97\u4f4d\u4fe1\u606f\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_post, title="\u5c97\u4f4d\u4fe1\u606f-\u5c97\u4f4d\u4fe1\u606f\u7f16\u8f91")
    public ResponseData editPostInfo(@RequestBody BPostEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.postProvider.editInfo(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5c97\u4f4d\u4fe1\u606f\u65b0\u589e")
    @PostMapping(value={"/add"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_post, title="\u5c97\u4f4d\u4fe1\u606f-\u5c97\u4f4d\u4fe1\u606f\u65b0\u589e")
    public ResponseData addPostInfo(@RequestBody BPostEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.postProvider.addInfo(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u5c97\u4f4d\u4fe1\u606f\u5220\u9664")
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_post, title="\u5c97\u4f4d\u4fe1\u606f-\u5c97\u4f4d\u4fe1\u606f\u5220\u9664")
    @PostMapping(value={"/remove"})
    public ResponseData removePostInfo(@RequestBody BPostEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.postProvider.removeInfo(param);
        return ResponseData.success();
    }
}

