/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgStatisticsParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgStatisticsVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgVo;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.vo.OrgStaffListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784"})
@RestController
@RequestMapping(value={"/orgStructure"})
public class OrgStructureController {
    private final IBOrgService bOrgService;
    private final IBCompanyService companyService;
    private final ICStaffBaseInfoService cStaffBaseInfoService;

    @ApiOperation(value="\u6811\u7ed3\u6784")
    @GetMapping(value={"/getTree"})
    public ResponseData<List<Tree<String>>> getTree(BOrgInfoParam param) {
        boolean sameHospital = this.companyService.isSameHospital(param.getCid(), ShiroUtil.getLoginUserCid());
        if (!sameHospital) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u5176\u4ed6\u533b\u9662\u4fe1\u606f");
        }
        return ResponseData.success(this.bOrgService.getTree(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"/getStaffList"})
    public ResponseData<LayuiGridData<List<OrgStaffListVo>>> getStaffList(StaffCmPageParam param) {
        return ResponseData.success(this.cStaffBaseInfoService.getListForOrg(param));
    }

    @ApiOperation(value="\u65b0\u589e")
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_org, title="\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784-\u65b0\u589e")
    @PostMapping(value={"/addInfo"})
    public ResponseData<BOrgVo> addInfo(@RequestBody BOrgEditParam param) {
        return ResponseData.success((Object)this.bOrgService.addInfo(param));
    }

    @ApiOperation(value="\u7f16\u8f91")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_org, title="\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784-\u7f16\u8f91")
    @PostMapping(value={"/editInfo"})
    public ResponseData<BOrgVo> editInfo(@RequestBody BOrgEditParam param) {
        return ResponseData.success((Object)this.bOrgService.editInfo(param));
    }

    @ApiOperation(value="\u5220\u9664")
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_org, title="\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784-\u5220\u9664")
    @PostMapping(value={"/removeInfo"})
    public ResponseData removeInfo(@RequestBody BOrgEditParam param) {
        this.bOrgService.removeInfo(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u6570")
    @GetMapping(value={"/getDepartmentNum"})
    public ResponseData<BOrgStatisticsVo> getDepartmentNum(BOrgStatisticsParam param) {
        return ResponseData.success((Object)this.bOrgService.getCountWithDepartmentNum(param));
    }

    public OrgStructureController(IBOrgService bOrgService, IBCompanyService companyService, ICStaffBaseInfoService cStaffBaseInfoService) {
        this.bOrgService = bOrgService;
        this.companyService = companyService;
        this.cStaffBaseInfoService = cStaffBaseInfoService;
    }
}

