/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCertChangeLogService;
import cn.smarthse.rho.modules.company.service.b.IBCertService;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBLivenessService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.sys.model.b.param.BCertChangeLogQueryParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.BLivenessEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyInfoChangeLogParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyLivenessIChangeLogParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCertChangeLogVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCertVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyCampusVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyFullInfoVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanyChangeLogVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanyLivenessChangeLogVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceRayStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmESourceNonSealedStatisticsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u9662\uff1a\u4fe1\u606f"})
@RequestMapping(value={"/companyInfo"})
public class CompanyInfoController
extends ControllerSupport {
    private final IBCompanyService bCompanyService;
    private final IBCertService bCertService;
    private final IEdeviceRayService eDeviceRayService;
    private final IEsourceNonSealedService eSourceNonSealedService;
    private final IEsourceSealedService eSourceSealedService;
    private final IBCertChangeLogService bCertChangeLogService;
    private final IBLivenessService livenessService;

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/getBaseInfo"})
    public ResponseData<BCompanyVo> getBaseInfo(BCompanyInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.bCompanyService.getBaseInfoById(param));
    }

    @ApiOperation(value="\u7f16\u8f91\u533b\u9662\u57fa\u7840\u4fe1\u606f")
    @PostMapping(value={"/edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_company, title="\u533b\u9662\uff1a\u4fe1\u606f-\u7f16\u8f91\u533b\u9662\u57fa\u7840\u4fe1\u606f")
    public ResponseData<String> edit(@RequestBody BCompanyEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getId())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.bCompanyService.editBaseInfo(param);
        return ResponseData.success((Object)"\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u9662\u5168\u4fe1\u606f")
    @GetMapping(value={"/getFullInfo"})
    public ResponseData<BCompanyFullInfoVo> getFullInfo(BCompanyInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        BCompanyFullInfoVo result = new BCompanyFullInfoVo();
        BCompanyVo baseInfo = this.bCompanyService.getBaseInfoById(param);
        List<BCompanyCampusVo> branchList = this.bCompanyService.getBranchListForCompany(param);
        BCertVo certInfo = this.bCertService.getBaseInfoForCompany(param);
        CmEDeviceRayStatisticsVo deviceRayStatisticsVo = this.eDeviceRayService.deviceRayStatisticsForCompany(param);
        CmESourceNonSealedStatisticsVo cmESourceNonSealedStatisticsVo = null;
        List<CmEDeviceStatisticsVo> sealedSourceStatisticsVo = null;
        List<CmEDeviceStatisticsVo> includeSealedSourceStatisticsVo = null;
        try {
            sealedSourceStatisticsVo = this.eSourceSealedService.sealedSourceStatistics(param);
            includeSealedSourceStatisticsVo = this.eSourceSealedService.includeSealedSourceStatistics(param);
            cmESourceNonSealedStatisticsVo = this.eSourceNonSealedService.sourceNonSealedStatisticsForCompany(param);
            CmESourceNonSealedStatisticsVo location = this.eSourceNonSealedService.sourceNonSealedStatisticsForCompanyLocation(param);
            cmESourceNonSealedStatisticsVo = cmESourceNonSealedStatisticsVo == null ? new CmESourceNonSealedStatisticsVo() : cmESourceNonSealedStatisticsVo;
            cmESourceNonSealedStatisticsVo.setALocationNum(Integer.valueOf(location == null ? 0 : location.getALocationNum()));
            cmESourceNonSealedStatisticsVo.setBLocationNum(Integer.valueOf(location == null ? 0 : location.getBLocationNum()));
            cmESourceNonSealedStatisticsVo.setCLocationNum(Integer.valueOf(location == null ? 0 : location.getCLocationNum()));
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        result.setBCompanyVo(baseInfo);
        result.setBranchList(branchList);
        result.setBCertVo(certInfo);
        result.setCmeDeviceRayStatisticsVo(deviceRayStatisticsVo);
        result.setCmESourceNonSealedStatisticsVo(cmESourceNonSealedStatisticsVo);
        result.setSealedSourceStatisticsVo(sealedSourceStatisticsVo);
        result.setIncludeSealedSourceStatisticsVo(includeSealedSourceStatisticsVo);
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="\u8bc1\u4e66\u6821\u9a8c\u8bb0\u5f55")
    @GetMapping(value={"/certChangeLog"})
    public ResponseData<LayuiGridData<BCertChangeLogVo>> certChangeLog(BCertChangeLogQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.bCertChangeLogService.getList(param));
    }

    @ApiOperation(value="\u4fe1\u606f\u4fee\u6539\u8bb0\u5f55")
    @GetMapping(value={"/infoChangeLog"})
    public ResponseData<LayuiGridData<CompanyChangeLogVo>> getChangeLog(CompanyInfoChangeLogParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.bCompanyService.getChangeLog(param));
    }

    @ApiOperation(value="\u6dfb\u52a0\u6d3b\u8dc3\u5ea6")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_company, title="\u533b\u9662\uff1a\u4fe1\u606f-\u6dfb\u52a0\u6d3b\u8dc3\u5ea6")
    @PostMapping(value={"/addLivenessInfo"})
    public ResponseData addLivenessInfo(@RequestBody BLivenessEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.livenessService.addInfo(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u7f16\u8f91\u6d3b\u8dc3\u5ea6")
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_company, title="\u533b\u9662\uff1a\u4fe1\u606f-\u7f16\u8f91\u6d3b\u8dc3\u5ea6")
    @PostMapping(value={"/editLivenessInfo"})
    public ResponseData editLivenessInfo(@RequestBody BLivenessEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.livenessService.editInfo(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u6d3b\u8dc3\u5ea6\u4fee\u6539\u8bb0\u5f55")
    @GetMapping(value={"/livenessChangeLog"})
    public ResponseData<LayuiGridData<CompanyLivenessChangeLogVo>> getLivenessChangeLog(CompanyLivenessIChangeLogParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.livenessService.getLivenessChangeLog(param));
    }

    public CompanyInfoController(IBCompanyService bCompanyService, IBCertService bCertService, IEdeviceRayService eDeviceRayService, IEsourceNonSealedService eSourceNonSealedService, IEsourceSealedService eSourceSealedService, IBCertChangeLogService bCertChangeLogService, IBLivenessService livenessService) {
        this.bCompanyService = bCompanyService;
        this.bCertService = bCertService;
        this.eDeviceRayService = eDeviceRayService;
        this.eSourceNonSealedService = eSourceNonSealedService;
        this.eSourceSealedService = eSourceSealedService;
        this.bCertChangeLogService = bCertChangeLogService;
        this.livenessService = livenessService;
    }
}

