/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.api;

import cn.hutool.core.util.IdUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.model.RSAVo;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.RsaUtil;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDetailParam;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceListDetailVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.time.Duration;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u5f00\u653e\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api"})
public class ApiController
extends ControllerSupport {
    @Autowired
    private IEdeviceService deviceService;

    @ApiOperation(value="\u5fc3\u8df3\u68c0\u6d4b")
    @PostMapping(value={"/health/beat"})
    public Object healthBeat() {
        return HttpStatus.OK;
    }

    @ApiOperation(value="RSA\uff1a\u83b7\u53d6\u516c\u94a5")
    @PostMapping(value={"/getPublicKey"})
    public ResponseData<RSAVo> getPublicKey() {
        String uuid = IdUtil.simpleUUID();
        Map rsaMap = RsaUtil.genKeyPair();
        RedisUtils.setCacheObject((String)RedisKey.RSA((String)uuid), rsaMap.get("privateKey"), (Duration)Duration.ofMinutes(30L));
        return ResponseData.success((Object)new RSAVo().setUuid(uuid).setPrivateKey((String)rsaMap.get("publicKey")));
    }

    @ApiOperation(value="RSA\uff1a\u52a0\u5bc6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="publicKey", value="\u516c\u94a5", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="content", value="\u5185\u5bb9", required=true, paramType="query", dataTypeClass=String.class)})
    @PostMapping(value={"/encrypt"})
    public ResponseData<String> encrypt(@NotEmpty String publicKey, @NotEmpty String content) {
        return ResponseData.success((Object)RsaUtil.encrypt((String)content, (String)publicKey));
    }

    @ApiOperation(value="\u63d0\u4f9b\u7ed9\u626b\u7801 - \u8bbe\u5907\u8be6\u60c5")
    @GetMapping(value={"/getDeviceForQR"})
    public ResponseData<EDeviceListDetailVo> getDeviceForQR(EDeviceDetailParam param) {
        return ResponseData.success((Object)this.deviceService.getDeviceDetailById(param));
    }
}

