/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller;

import cn.smarthse.common.annotation.password.OperatorDataSourceEnum;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.annotation.RequestLimit;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.RsaUtil;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.model.b.CompanyBatchVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=2, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u4e2a\u4eba\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"/uc"})
@Validated
public class UcController
extends ControllerSupport {
    private final IBCompanyService companyService;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;

    @ApiOperation(value="\u9662\u533a\u4e0b\u62c9\u5217\u8868")
    @GetMapping(value={"/getCompanyBatchList"})
    public ResponseData<List<CompanyBatchVo>> getCompanyBatchList() {
        List<CompanyBatchVo> rst = this.companyService.getCompanyBatchChooseList(ShiroUtil.getLoginUserCid());
        Long loginUserCid = ShiroUtil.getLoginUserCid();
        rst.stream().peek(i -> {
            if (i.getCid().longValue() == loginUserCid.longValue()) {
                i.setIsChoose(Integer.valueOf(1));
            }
        }).collect(Collectors.toList());
        return ResponseData.success(rst);
    }

    @ApiOperation(value="\u5207\u6362\u9662\u533a")
    @PostMapping(value={"/reflush"})
    public ResponseData<Long> reflush(@Validated @RequestBody IdParam param) {
        if (Objects.equals(param.getId(), ShiroUtil.getLoginUserCid())) {
            return ResponseData.success((Object)param.getId());
        }
        List<CompanyBatchVo> batchList = this.companyService.getCompanyBatchChooseList(ShiroUtil.getLoginUserCid());
        if (CollectionUtils.isEmpty(batchList)) {
            return ResponseData.fail((String)"\u67e5\u65e0\u5206\u9662\u4fe1\u606f\uff0c\u5207\u6362\u5931\u8d25\uff01");
        }
        List batchIdList = batchList.stream().map(CompanyBatchVo::getCid).collect(Collectors.toList());
        if (!batchIdList.contains(param.getId())) {
            return ResponseData.fail((String)"\u975e\u6cd5\u64cd\u4f5c\uff01");
        }
        RedisUtils.setCacheObject((String)RedisKey.getLoginCidKey((Long)ShiroUtil.getLoginUserId()), (Object)param.getId());
        return ResponseData.success((Object)param.getId());
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/getPrinciple"})
    public ResponseData<ShiroPrincipal> getPrinciple() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return ResponseData.success((Object)principal);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801\uff08rsa\u52a0\u5bc632\u4f4d\u5c0f\u5199md5\u5bc6\u7801\uff09", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="password", value="\u65b0\u5bc6\u7801\uff08rsa\u52a0\u5bc632\u4f4d\u5c0f\u5199md5\u5bc6\u7801\uff09", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="uuid", value="\u516c\u94a5uuid", required=true, paramType="query", dataTypeClass=String.class)})
    @Log(type=LogTypeEnum.type_opt_changePass, logModule=LogModuleTypeEnum.com_uc, dataOf=OperatorDataSourceEnum.RHO_COMPANY)
    @RequestLimit(second=60, maxCount=5)
    @PostMapping(value={"/changePasswordByOld"})
    public ResponseData<String> changePasswordByOld(@NotBlank(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotBlank(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotBlank(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") String uuid) {
        String privateKey = (String)RedisUtils.getCacheObject((String)RedisKey.RSA((String)uuid));
        if (privateKey == null) {
            return ResponseData.fail((String)"\u5bc6\u7801\u516c\u94a5\u5bc6\u94a5\u8fc7\u671f\uff01");
        }
        password = RsaUtil.decrypt((String)password, (String)privateKey);
        oldPassword = RsaUtil.decrypt((String)oldPassword, (String)privateKey);
        Long userId = ShiroUtil.getLoginUserId();
        this.sysUserServiceProvider.changePassword(userId, oldPassword, password);
        RedisUtils.deleteObject((String)RedisKey.getCompanyLoginUserKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getCompanyLoginTokenKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getLoginCidKey((Long)userId));
        return ResponseData.success((Object)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    public UcController(IBCompanyService companyService) {
        this.companyService = companyService;
    }
}

