/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller;

import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.annotation.RequestLimit;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.AesUtil;
import cn.smarthse.core.framework.utils.RsaUtil;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.rho.modules.company.bootstrap.security.model.param.CasLoginBody;
import cn.smarthse.rho.modules.company.bootstrap.security.model.param.PasswordAndCidLoginBody;
import cn.smarthse.rho.modules.company.bootstrap.security.model.param.PasswordLoginBody;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.CaptchaVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginByCreditCodeVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.enums.user.UserResourceEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import com.alibaba.fastjson.JSONObject;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u767b\u5f55"})
@RestController
@RequestMapping(value={"/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final SysProperties sysProperties;
    private final IBCompanyService companyService;
    @DubboReference
    private ICompanyProvider companyProvider;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @PostMapping(value={"/logout"})
    public ResponseData<String> logout() {
        this.loginService.logout(JwtUtil.getUserId());
        return ResponseData.success((Object)"\u9000\u51fa\u6210\u529f");
    }

    @ApiOperation(value="\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/vCode"})
    public ResponseData<CaptchaVo> vCode() {
        return ResponseData.success((Object)this.loginService.vCode());
    }

    @ApiOperation(value="\u5bc6\u7801\u767b\u5f55")
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.com_uc, title="\u8d26\u53f7\u5bc6\u7801\u767b\u5f55")
    @RequestLimit(second=60, maxCount=5, expression="#loginBody.username")
    @PostMapping(value={"/password"})
    public ResponseData<LoginVo> loginByPassword(@Validated @RequestBody PasswordLoginBody loginBody) {
        String privateKey = (String)RedisUtils.getCacheObject((String)RedisKey.RSA((String)loginBody.getRsaUuid()));
        if (privateKey == null) {
            return ResponseData.fail((String)"\u5bc6\u7801\u516c\u94a5\u5bc6\u94a5\u8fc7\u671f\uff01");
        }
        this.loginService.checkVcode(loginBody.getUuid(), loginBody.getCode());
        LoginVo result = this.loginService.loginByPassword(loginBody.getUsername(), RsaUtil.decrypt((String)loginBody.getPassword(), (String)privateKey));
        result.setRedirectUrl(loginBody.getRedirectUrl());
        return ResponseData.success((Object)result);
    }

    @RequestLimit(second=60, maxCount=5, expression="#creditCode")
    @PostMapping(value={"getByCreditCode"})
    public ResponseData<List<LoginByCreditCodeVo>> getByCreditCode(@NotBlank(message="\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a") String creditCode) {
        return ResponseData.success(this.companyService.getLoginByCreditCode(creditCode));
    }

    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.com_uc, title="\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u767b\u5f55")
    @RequestLimit(second=60, maxCount=5, expression="#loginBody.cid")
    @PostMapping(value={"loginByPasswordAndCid"})
    public ResponseData<LoginVo> loginByPasswordAndCid(@Validated @RequestBody PasswordAndCidLoginBody loginBody) {
        String privateKey = (String)RedisUtils.getCacheObject((String)RedisKey.RSA((String)loginBody.getRsaUuid()));
        if (privateKey == null) {
            return ResponseData.fail((String)"\u5bc6\u7801\u516c\u94a5\u5bc6\u94a5\u8fc7\u671f\uff01");
        }
        this.loginService.checkVcode(loginBody.getUuid(), loginBody.getCode());
        loginBody.setPassword(RsaUtil.decrypt((String)loginBody.getPassword(), (String)privateKey));
        LoginVo result = this.loginService.loginByPasswordAndCid(loginBody);
        result.setRedirectUrl(loginBody.getRedirectUrl());
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u533b\u9662\u7aef")
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.com_uc, title="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u533b\u9662\u7aef")
    @PostMapping(value={"/cas"})
    public ResponseData<LoginVo> loginByCas(@NotBlank String sign) {
        String decrypt = AesUtil.decrypt((String)sign, (String)this.sysProperties.healthOnlineTrainingAesKey);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        Long cid = (Long)jsonObject.getObject("cid", Long.class);
        Long superuserId = (Long)jsonObject.getObject("superuserId", Long.class);
        String superuserName = (String)jsonObject.getObject("superuserName", String.class);
        Long superuserAreaId = (Long)jsonObject.getObject("superuserAreaId", Long.class);
        Integer userResource = (Integer)jsonObject.getObject("userResource", Integer.class);
        Long time = (Long)jsonObject.getObject("time", Long.class);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class);
        long expireTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        if (UserResourceEnum.getName((Integer)userResource) == null) {
            return ResponseData.fail((String)"\u5355\u70b9\u7528\u6237\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        extraData.put("superuserId", superuserId);
        extraData.put("superuserName", superuserName);
        extraData.put("superuserArea", this.sysAreaProvideService.getAreaByIdV3(superuserAreaId));
        CasLoginBody casToken = new CasLoginBody(cid, userResource, extraData);
        LoginVo result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u533b\u9662\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u5728\u7ebf\u57f9\u8bad\u4f01\u4e1a\u7aef")
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.com_uc, title="\u653e\u5c04\u536b\u751f\u533b\u9662\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u5728\u7ebf\u57f9\u8bad\u4f01\u4e1a\u7aef")
    @GetMapping(value={"/toThird"})
    public ResponseData<String> toOnlineTrain(@RequestParam(value="redirectUrl", required=false) String redirectUrl, @RequestParam(value="loginUserType", defaultValue="0") Integer loginUserType) {
        Long cid = JwtUtil.getCid();
        BCompanyVo company = this.companyProvider.getCompany(cid);
        if (Objects.isNull(company)) {
            return ResponseData.fail((String)"\u627e\u4e0d\u5230\u8be5\u533b\u9662\u76f8\u5173\u4fe1\u606f");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("time", (Object)System.currentTimeMillis());
        jsonObject.put("redirectUrl", (Object)(StringUtils.hasLength((String)redirectUrl) ? redirectUrl : this.sysProperties.healthOnlineTrainingRedirectUrl));
        jsonObject.put("username", (Object)JwtUtil.getUsername());
        jsonObject.put("token", (Object)cid);
        jsonObject.put("name", (Object)company.getName());
        jsonObject.put("creditCode", (Object)company.getCreditCode());
        jsonObject.put("areaId", (Object)company.getAreaId());
        jsonObject.put("isTest", (Object)company.getIsTest());
        String sign = AesUtil.encrypt((String)jsonObject.toString(), (String)this.sysProperties.healthOnlineTrainingAesKey);
        return ResponseData.success((Object)(this.sysProperties.healthOnlineTrainingUrl + "?sign=" + sign + "&type=4&loginUserType=" + loginUserType));
    }

    public LoginController(LoginService loginService, SysProperties sysProperties, IBCompanyService companyService) {
        this.loginService = loginService;
        this.sysProperties = sysProperties;
        this.companyService = companyService;
    }
}

