/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.utils;

import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.constant.LoginTypeConstants;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginSysUser;
import java.util.Map;
import java.util.Objects;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        return (ShiroPrincipal)ShiroUtil.getSubject().getPrincipal();
    }

    public static LoginSysUser getUser() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getUser() : null;
    }

    public static Long getLoginUserId() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getId() : null;
    }

    public static Long getLoginUserCid() {
        String cid = (String)RedisUtils.getCacheObject((String)RedisKey.getLoginCidKey((Long)ShiroUtil.getLoginUserId()));
        return cid == null ? ShiroUtil.getLoginUserOriginalCid() : Long.valueOf(cid);
    }

    public static Long getLoginUserOriginalCid() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getCid() : null;
    }

    public static String getLoginUsername() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginFullName() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getFullName() : null;
    }

    public static SysAreaV3OneVo getLoginUserArea() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getSysArea() : null;
    }

    public static Long getLoginUserAreaId() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getAreaId() : null;
    }

    public static Byte getLoginUserAreaLevel() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getAreaLevel() : null;
    }

    public static Boolean getLoginUserIsTest() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getIsTest() == 1 : Boolean.FALSE;
    }

    public static String getLoginMedicalNucode() {
        LoginSysUser user = ShiroUtil.getUser();
        return user != null ? user.getMedicalNucode() : null;
    }

    public static Map<String, Object> extraData() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getExtraData() : null;
    }

    public static Long getLoginUserSuperuserId() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? (Objects.equals(principal.getLoginType(), LoginTypeConstants.LOGIN_CAS) ? (Long)principal.getExtraData().get("superuserId") : null) : null;
    }

    public static String getLoginUserSuperuserName() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? (Objects.equals(principal.getLoginType(), LoginTypeConstants.LOGIN_CAS) ? (String)principal.getExtraData().get("superuserName") : null) : null;
    }
}

