/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.util.IdUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.captcha.RandomNumberGenerator;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.model.param.CasLoginBody;
import cn.smarthse.rho.modules.company.bootstrap.security.model.param.PasswordAndCidLoginBody;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.CaptchaVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginSysUser;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.company.bootstrap.security.service.PermissionsService;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.provider.sys.ISysRoleServiceProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import java.awt.Font;
import java.time.Duration;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    private final SysProperties sysProperties;
    private final PermissionsService permissionsService;
    private final IBCompanyService companyService;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference
    private ISysRoleServiceProvider sysRoleServiceProvider;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public void logout(Long userId) {
        RedisUtils.deleteObject((String)RedisKey.getCompanyLoginUserKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getCompanyLoginTokenKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getLoginCidKey((Long)userId));
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            subject.logout();
        }
    }

    public CaptchaVo vCode() {
        String uuid = IdUtil.simpleUUID();
        LineCaptcha captcha = CaptchaUtil.createLineCaptcha((int)130, (int)48, (CodeGenerator)new RandomNumberGenerator("0123456789", 4), (int)9);
        captcha.setFont(new Font("SansSerif", 1, 43));
        String code = captcha.getCode();
        RedisUtils.setCacheObject((String)RedisKey.getVCodeKey((String)uuid), (Object)code, (Duration)Duration.ofMinutes(Constant.Vcode.CODE_EXPIRE_TIME.intValue()));
        CaptchaVo captchaVo = new CaptchaVo();
        captchaVo.setUuid(uuid);
        captchaVo.setImg(captcha.getImageBase64Data());
        return captchaVo;
    }

    public void checkVcode(String key, String vcode) {
        Object vodeCache = RedisUtils.getCacheObject((String)RedisKey.getVCodeKey((String)key));
        if (Objects.isNull(vodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!vcode.equalsIgnoreCase(vodeCache.toString())) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
    }

    public LoginVo loginByPassword(String username, String password) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (LockedAccountException e) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef5\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f8530\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775\u3002");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (ExcessiveAttemptsException e) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef3\u6b21\uff0c\u82e5\u518d\u9519\u8bef2\u6b21\uff0c\u60a8\u7684\u8d26\u53f7\u5c06\u4f1a\u88ab\u9501\u5b9a30\u5206\u949f\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u5ba2\u670d(0571-89978771/89978775)\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (UnauthorizedException e) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
        catch (Exception e) {
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginVo loginByPasswordAndCid(PasswordAndCidLoginBody token) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (LockedAccountException e) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef5\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f8530\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775\u3002");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (ExcessiveAttemptsException e) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef3\u6b21\uff0c\u82e5\u518d\u9519\u8bef2\u6b21\uff0c\u60a8\u7684\u8d26\u53f7\u5c06\u4f1a\u88ab\u9501\u5b9a30\u5206\u949f\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u5ba2\u670d(0571-89978771/89978775)\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (UnauthorizedException e) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
        catch (Exception e) {
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginVo loginByCas(CasLoginBody token) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            return this.returnLoginInitParam((ShiroPrincipal)subject.getPrincipal());
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (UnauthorizedException e) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
        catch (Exception e) {
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private LoginVo returnLoginInitParam(ShiroPrincipal principal) {
        Long userId = principal.getUserId();
        String username = principal.getUser().getUsername();
        String fullName = principal.getUser().getFullName();
        Long cid = principal.getUser().getCid();
        Long areaId = principal.getUser().getAreaId();
        Integer isTest = principal.getUser().getIsTest();
        this.permissionsService.addRoleAndPerms(principal);
        Integer loginType = principal.getLoginType();
        String token = JwtUtil.createToken((Long)userId, (String)username, (String)fullName, (Long)cid, (Long)cid, (Long)areaId, (Integer)isTest, (Integer)loginType, (String)this.sysProperties.getLogin().getSecret(), (Long)Constant.TOKEN_EXPIRE_TIME);
        RedisUtils.setCacheObject((String)RedisKey.getCompanyLoginUserKey((Long)userId), (Object)principal, (Duration)Duration.ofMinutes(Constant.REDIS_PRINCIPAL_TIME));
        RedisUtils.setCacheObject((String)RedisKey.getCompanyLoginTokenKey((Long)userId), (Object)token, (Duration)Duration.ofMinutes(Constant.REDIS_TOKEN_EXPIRE_TIME));
        RedisUtils.setCacheObject((String)RedisKey.getLoginCidKey((Long)ShiroUtil.getLoginUserId()), (Object)cid);
        return new LoginVo(token);
    }

    public ShiroPrincipal getLoginUser(Long userId) {
        if (userId == null) {
            return null;
        }
        String loginUserKey = RedisKey.getCompanyLoginUserKey((Long)userId);
        ShiroPrincipal principal = (ShiroPrincipal)RedisUtils.getCacheObject((String)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            SysUser user = this.sysUserServiceProvider.getUserById(userId);
            if (user == null) {
                throw new UnknownAccountException();
            }
            if (Objects.equals(user.getIsForbidden(), Constant.ACTIVE_YES)) {
                throw new DisabledAccountException();
            }
            principal.setUser(this.toggleSysUser(user));
            this.permissionsService.addRoleAndPerms(principal);
            RedisUtils.setCacheObject((String)loginUserKey, (Object)principal, (Duration)Duration.ofMinutes(Constant.REDIS_PRINCIPAL_TIME));
            return principal;
        }
        return principal;
    }

    public LoginSysUser toggleSysUser(SysUser user) {
        BCompany company = (BCompany)this.companyService.getById(user.getCid());
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
        LoginSysUser result = new LoginSysUser();
        result.setId(user.getId()).setCid(user.getCid()).setMedicalNucode(company.getMedicalNucode()).setUsername(user.getUsername()).setFullName(user.getNickname()).setIsTest(company.getIsTest()).setIsDefaultPwd(user.getIsDefaultPwd()).setChangePwDate(user.getChangePwDate()).setRoleList(this.sysRoleServiceProvider.getRoleListByUserId(user.getId())).setSysArea(area).setAreaId(area.getId()).setAreaLevel(area.getLevel());
        return result;
    }

    public LoginService(SysProperties sysProperties, PermissionsService permissionsService, IBCompanyService companyService) {
        this.sysProperties = sysProperties;
        this.permissionsService = permissionsService;
        this.companyService = companyService;
    }
}

