/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.realms;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PasswordRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(PasswordRealm.class);
    @Autowired
    private LoginService loginService;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        SysUser user = this.sysUserServiceProvider.getUserByUsername(token.getUsername());
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (Objects.equals(user.getIsForbidden(), Constant.ACTIVE_YES)) {
            throw new DisabledAccountException();
        }
        String credentials = user.getPassword();
        String realmName = super.getName();
        ByteSource credentialsSalt = ByteSource.Util.bytes((String)user.getSalt());
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(this.loginService.toggleSysUser(user)), (Object)credentials, credentialsSalt, realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

