/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.realms;

import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JwtRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(JwtRealm.class);
    @Autowired
    private LoginService loginService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof BearerToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        BearerToken bearerToken = (BearerToken)authenticationToken;
        String token = bearerToken.getToken();
        ShiroPrincipal principal = this.loginService.getLoginUser(JwtUtil.getUserId((String)token));
        return new SimpleAuthenticationInfo((Object)principal, (Object)token, this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Object obj = super.getAvailablePrincipal(principals);
        if (!(obj instanceof ShiroPrincipal)) {
            return info;
        }
        ShiroPrincipal principal = (ShiroPrincipal)obj;
        info.setStringPermissions(principal.getPermissionsSet());
        info.setRoles(principal.getRoleSet());
        return info;
    }
}

