/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.realms;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.constant.LoginTypeConstants;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.model.param.CasLoginBody;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CasRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(CasRealm.class);
    @Autowired
    private LoginService loginService;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;

    public boolean supports(AuthenticationToken token) {
        return token instanceof CasLoginBody;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        CasLoginBody token = (CasLoginBody)authenticationToken;
        SysUser user = this.sysUserServiceProvider.getUserByUsername((String)token.getPrincipal());
        if (user == null) {
            user = this.sysUserServiceProvider.addUserForCas(token.getCid(), (String)token.getPrincipal(), token.getUserResource());
        }
        if (Objects.equals(user.getIsForbidden(), Constant.ACTIVE_YES)) {
            throw new DisabledAccountException();
        }
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(this.loginService.toggleSysUser(user), LoginTypeConstants.LOGIN_CAS, token.getExtraData()), token.getCredentials(), super.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

