/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.filter;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.constant.LoginTypeConstants;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.core.framework.utils.ServletUtils;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.time.Duration;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.BearerToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtFilter.class);
    private final SysProperties sysProperties;
    private static final SerializeConfig CONFIG = new SerializeConfig();

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        return StrUtil.isNotEmpty((CharSequence)this.getAuthorization((HttpServletRequest)request));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
        return false;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginAttempt(request, response)) {
            return this.executeLogin(request, response);
        }
        return false;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (JwtUtil.isTokenExpired((String)token).booleanValue()) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        if (!JwtUtil.verify((String)token, (String)this.sysProperties.getLogin().getSecret())) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u975e\u6cd5\u7b7e\u540d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        if (!(Objects.equals(JwtUtil.getLoginType(), LoginTypeConstants.LOGIN_CAS) || this.sysProperties.getLogin().isMultiLogin() || Objects.equals(JwtUtil.getIsTest((String)token), 1))) {
            String redisToken = (String)RedisUtils.getCacheObject((String)RedisKey.getCompanyLoginTokenKey((Long)JwtUtil.getUserId((String)token)));
            if (redisToken == null) {
                this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
                return false;
            }
            if (!token.equals(redisToken)) {
                this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u8d26\u53f7\u5728\u5176\u4ed6\u8bbe\u5907\u4e0a\u767b\u5f55\uff01"), response);
                return false;
            }
        }
        long exp = JwtUtil.getExpirationMillis((String)token);
        long curr = System.currentTimeMillis();
        if (curr < exp && exp - Constant.REFRESH_TOKEN_BEGIN_TIME_REST <= curr) {
            this.refreshToken(token, (HttpServletResponse)response);
        }
        BearerToken bearerToken = new BearerToken(token);
        try {
            this.getSubject(request, response).login((AuthenticationToken)bearerToken);
        }
        catch (IncorrectCredentialsException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.UNAUTHORIZED.getValue(), "\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        catch (AuthenticationException e) {
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.fail.getValue(), "\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01"), response);
            return false;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            this.returnErr((ResponseData<Object>)new ResponseData(ResponseStateEnum.INTERNAL_SERVER_ERROR.getValue()), response);
            return false;
        }
        return true;
    }

    private void refreshToken(String token, HttpServletResponse httpServletResponse) {
        String refreshToken = JwtUtil.refreshToken((String)token, (String)this.sysProperties.getLogin().getSecret());
        httpServletResponse.setHeader(Constant.REFRESH_TOKEN_HEADER_NAME, refreshToken);
        RedisUtils.setCacheObject((String)RedisKey.getCompanyLoginTokenKey((Long)JwtUtil.getUserId((String)token)), (Object)refreshToken, (Duration)Duration.ofMinutes(Constant.REDIS_TOKEN_EXPIRE_TIME));
    }

    private String getAuthorization(HttpServletRequest httpRequest) {
        String authorization = httpRequest.getHeader(Constant.TOKEN_HEADER_NAME);
        if (StrUtil.isEmpty((CharSequence)authorization)) {
            authorization = httpRequest.getParameter(Constant.TOKEN_HEADER_NAME);
        }
        return authorization;
    }

    private void returnErr(ResponseData<Object> data, ServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        ServletUtils.renderString((HttpServletResponse)((HttpServletResponse)response), (String)JSON.toJSONString(data, (SerializeConfig)CONFIG, (SerializerFeature[])new SerializerFeature[0]));
    }

    public JwtFilter(SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }

    static {
        CONFIG.configEnumAsJavaBean(new Class[]{ResponseStateEnum.class});
    }
}

