/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.aop;

import cn.smarthse.core.framework.model.PageParam;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=3)
public class ParamAopAspect {
    private static final Logger log = LoggerFactory.getLogger(ParamAopAspect.class);

    @Pointcut(value="execution(public * cn.smarthse..*.controller..*.*(..))")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
        this.initParam(point.getArgs(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
    }

    private void initParam(Object[] args, HttpServletRequest request) {
        if (args == null) {
            return;
        }
        for (Object arg : args) {
            if (!(arg instanceof PageParam)) continue;
            Long cid = ((PageParam)arg).getCid();
            ((PageParam)arg).setCid(cid != null ? cid : ShiroUtil.getLoginUserCid());
        }
    }
}

