/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.aop;

import cn.hutool.extra.servlet.ServletUtil;
import cn.smarthse.common.annotation.password.BusinessStatusEnum;
import cn.smarthse.common.annotation.password.BusinessTypeEnum;
import cn.smarthse.common.annotation.password.OperatorDataSourceEnum;
import cn.smarthse.common.util.passwordLog.AddressUtils;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.core.framework.utils.ServletUtils;
import cn.smarthse.core.framework.utils.SpringContextHolder;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.modules.datacentre.model.log.SysOperLog;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.enums.user.UserTypeEnum;
import cn.smarthse.rho.modules.sys.model.sys.param.SysLogAddParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.DubboReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final ThreadPoolTaskExecutor taskExecutor;
    @DubboReference
    private ISysLogProvider sysLogService;
    @DubboReference
    private ISysOperLogProviderService sysOperLogProviderService;

    @Pointcut(value="@annotation(cn.smarthse.core.framework.annotation.Log)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void beforeControllerMethod(JoinPoint joinPoint) {
    }

    @AfterThrowing(value="pointcut()")
    public void afterControllerMethodThrows(JoinPoint joinPoint) {
    }

    @After(value="pointcut()")
    public void afterCompletion(JoinPoint joinPoint) {
    }

    @AfterReturning(value="pointcut()", returning="jsonResult")
    public void afterControllerMethodReturns(JoinPoint joinPoint, Object jsonResult) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof MultipartFile || args[i] instanceof HttpServletRequest || args[i] instanceof HttpServletResponse) continue;
                map.put(paramNames[i], args[i]);
            }
        }
        map.put("jsonResult", jsonResult);
        map.put("className", joinPoint.getTarget().getClass().getName());
        map.put("methodName", signature.getName());
        this.addLog(args, signature.getMethod().getAnnotation(Log.class), map);
    }

    private void addLog(Object[] args, Log logAnno, Map<String, Object> map) {
        ShiroPrincipal principal = (ShiroPrincipal)ShiroUtil.getSubject().getPrincipal();
        if (principal == null) {
            return;
        }
        if (logAnno != null) {
            HttpServletRequest request = ServletUtils.getRequest();
            Long userId = ShiroUtil.getLoginUserId();
            String username = ShiroUtil.getLoginUsername();
            String name = ShiroUtil.getLoginFullName();
            SysAreaV3OneVo area = ShiroUtil.getLoginUserArea();
            Long areaId = ShiroUtil.getLoginUserAreaId();
            Long cid = ShiroUtil.getLoginUserCid();
            int type = UserTypeEnum.company.getValue();
            String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
            if (logAnno.type() == LogTypeEnum.type_opt_reset || logAnno.type() == LogTypeEnum.type_opt_changePass) {
                SysOperLog passLog = new SysOperLog();
                passLog.setTitle("\u5bc6\u7801\u53d8\u66f4");
                passLog.setOperName(username);
                passLog.setMethod(StringUtils.substring((String)(map.get("className") + "." + map.get("methodName") + "()"), (int)0, (int)1000));
                passLog.setRequestMethod(request.getMethod());
                passLog.setOperUrl(request.getRequestURI().toString());
                passLog.setOperIp(ip);
                passLog.setOperLocation(AddressUtils.getRealAddressByIP((String)passLog.getOperIp()));
                if (map.containsKey("param")) {
                    passLog.setOperParam(StringUtils.substring((String)JSON.toJSONString((Object)map.get("param")), (int)0, (int)2000));
                } else {
                    passLog.setOperParam(StringUtils.substring((String)JSON.toJSONString((Object)args), (int)0, (int)2000));
                }
                String jsonResult = JSON.toJSONString((Object)map.get("jsonResult"));
                passLog.setJsonResult(StringUtils.substring((String)jsonResult, (int)0, (int)2000));
                ResponseData responseData = (ResponseData)JSON.parseObject((String)jsonResult, ResponseData.class);
                passLog.setStatus(Objects.equals(responseData.getState(), ResponseStateEnum.success.getValue()) ? BusinessStatusEnum.SUCCESS.getValue() : BusinessStatusEnum.FAIL.getValue());
                passLog.setIsValid(Boolean.valueOf(true));
                passLog.setCreateBy(userId);
                passLog.setCreateDate(new Date());
                passLog.setUpdateBy(userId);
                passLog.setUpdateDate(new Date());
                passLog.setDataSource(OperatorDataSourceEnum.RHO_COMPANY.getValue());
                passLog.setDataOf(OperatorDataSourceEnum.RHO_COMPANY.getValue());
                if (logAnno.type() == LogTypeEnum.type_opt_reset) {
                    passLog.setBusinessType(BusinessTypeEnum.RESETPASSWORD.getValue());
                } else if (logAnno.type() == LogTypeEnum.type_opt_changePass) {
                    passLog.setBusinessType(BusinessTypeEnum.CHANGEPASSWORD.getValue());
                    passLog.setPassword((String)map.get("oldPassword"));
                }
                if (map.containsKey("param")) {
                    if (map.get("param") instanceof IdParam) {
                        IdParam param = (IdParam)map.get("param");
                        SysUser user = ((ISysUserServiceProvider)SpringContextHolder.getBean(ISysUserServiceProvider.class)).getUserById(param.getId());
                        passLog.setCid(user.getCid());
                        passLog.setUserName(user.getUsername());
                    }
                } else {
                    passLog.setCid(cid);
                    passLog.setUserName(username);
                }
                this.taskExecutor.execute(() -> this.sysOperLogProviderService.insertOperlog(passLog));
            } else {
                SysLogAddParam syslog = new SysLogAddParam();
                syslog.setUserId(userId);
                syslog.setUsername(username);
                syslog.setFullname(name);
                syslog.setProvinceId(area.getProvinceId());
                syslog.setCityId(area.getCityId());
                syslog.setAreaId(area.getAreaId());
                syslog.setStreetId(area.getStreetId());
                syslog.setDetailAreaId(areaId);
                syslog.setCid(cid);
                syslog.setResource(Integer.valueOf(logAnno.logModule() == LogModuleTypeEnum.anon ? type : logAnno.logModule().resource));
                syslog.setTitle(logAnno.title());
                syslog.setType(logAnno.type().value);
                syslog.setModuleType(logAnno.logModule().moduleType);
                syslog.setRequestMethod(request.getMethod());
                syslog.setRemoteIp(ip);
                syslog.setParams(JSON.toJSONString(map));
                syslog.setRequestUri(request.getRequestURI());
                syslog.setUserAgent(request.getHeader("user-agent"));
                syslog.setCreateBy(userId);
                if (log.isDebugEnabled()) {
                    log.debug("LogAspect.addLog: [{}: {}]: {}, {}, {}, {}", new Object[]{userId, username, syslog.getTitle(), syslog.getRequestUri(), syslog.getRemoteIp(), syslog.getParams()});
                }
                try {
                    if (this.taskExecutor != null) {
                        this.taskExecutor.execute(() -> this.sysLogService.addLog(syslog));
                    } else {
                        this.sysLogService.addLog(syslog);
                    }
                }
                catch (Exception e) {
                    log.error("Exception: ", (Throwable)e);
                }
            }
        }
    }

    private String invokeExpression(Method method, Object[] args, String expression) {
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return null;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(method);
        try {
            if (parameterNames != null) {
                for (int i = 0; i < parameterNames.length; ++i) {
                    context.setVariable(parameterNames[i], args[i]);
                }
            }
        }
        catch (Exception e) {
            log.error("invokeExpression\uff1a", (Throwable)e);
        }
        return String.valueOf(new SpelExpressionParser().parseExpression(expression).getValue((EvaluationContext)context));
    }

    public LogAspect(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

