/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.aop;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.UserEditParam;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.rho.modules.sys.enums.user.UserTypeEnum;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.config.annotation.DubboReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=2)
public class EditParamAopAspect {
    private static final Logger log = LoggerFactory.getLogger(EditParamAopAspect.class);
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    @Pointcut(value="execution(public * cn.smarthse..*.controller..*.*(..))")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
        this.initUserEditParam(point.getArgs(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
    }

    private void initUserEditParam(Object[] args, HttpServletRequest request) {
        if (args == null) {
            return;
        }
        for (Object arg : args) {
            String token;
            if (!(arg instanceof UserEditParam) || (token = request.getHeader(Constant.TOKEN_HEADER_NAME)) == null || token.isEmpty()) continue;
            ((UserEditParam)arg).setLoginUserId(JwtUtil.getUserId((String)token));
            ((UserEditParam)arg).setLoginName(JwtUtil.getFullName((String)token));
            ((UserEditParam)arg).setLoginUsername(JwtUtil.getUsername((String)token));
            Long areaId = JwtUtil.getAreaId((String)token);
            ((UserEditParam)arg).setLoginAreaId(areaId);
            ((UserEditParam)arg).setLoginAreaLevel(this.sysAreaProvider.getLevel(areaId));
            ((UserEditParam)arg).setLoginUserType(UserTypeEnum.company.getValue());
            ((UserEditParam)arg).setLoginCid(JwtUtil.getCid());
        }
    }
}

