/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap;

import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.mybatis.DataChangeRecorderInnerInterceptor;
import cn.smarthse.core.framework.mybatis.InjectionMetaObjectHandler;
import cn.smarthse.core.framework.service.EasySqlInjector;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"cn.smarthse.rho.modules.company.dao", "cn.smarthse.core.framework.mybatis"})
public class MybatisConfig {
    private final SysProperties sysProperties;

    @Bean
    public EasySqlInjector easySqlInjector() {
        return new EasySqlInjector();
    }

    @Bean
    @ConditionalOnProperty(prefix="sys.data-change-recorder", name={"enable"}, havingValue="true")
    public DataChangeRecorderInnerInterceptor DataChangeRecorderInnerInterceptor() {
        return new DataChangeRecorderInnerInterceptor(this.sysProperties.getDataChangeRecorder());
    }

    @Bean
    OptimisticLockerInnerInterceptor optimisticLockerInnerInterceptor() {
        return new OptimisticLockerInnerInterceptor();
    }

    @Bean
    public MetaObjectHandler metaObjectHandler() {
        return new InjectionMetaObjectHandler();
    }

    public MybatisConfig(SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }
}

