/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap;

import cn.smarthse.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.filter.CommonFilter;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.rho.modules.company.bootstrap.interceptor.BigDataLogInterceptor;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    @Autowired
    private OssClientProperties ossClientProperties;
    @Autowired
    private SysProperties sysProperties;
    @DubboReference
    private IBigDataLogProviderService bigDataLogProviderService;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        log.debug("\u914d\u7f6e\u9759\u6001\u8d44\u6e90\u8bbf\u95ee\u5904\u7406\u5668");
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + this.ossClientProperties.getOss_local() + "upload/"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new BigDataLogInterceptor(this.sysProperties, this.bigDataLogProviderService)).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public FilterRegistrationBean<Filter> filterRegistrationCommon() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CommonFilter());
        ArrayList<String> urlList = new ArrayList<String>();
        urlList.add("/*");
        registration.setUrlPatterns(urlList);
        registration.setName("CommonFilter");
        registration.setOrder(1);
        return registration;
    }
}

