/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.core.framework.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringUtils.class);
    private static final char SEPARATOR = '_';
    private static final String CHARSET_NAME = "UTF-8";

    public static boolean isValid(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return false;
        }
        if (password.length() < 8 || password.length() > 16) {
            return false;
        }
        boolean hasDigit = password.matches(".*[0-9].*");
        boolean hasLower = password.matches(".*[a-z].*");
        boolean hasUpper = password.matches(".*[A-Z].*");
        boolean hasSpecial = password.matches(".*[!@#$%^&*].*");
        if (!(hasDigit && hasLower && hasUpper && hasSpecial)) {
            return false;
        }
        if (password.matches(".*([a-zA-Z0-9])\\1\\1+.*")) {
            return false;
        }
        Pattern numSeqPattern = Pattern.compile("\\d{3,}");
        Matcher matcher = numSeqPattern.matcher(password);
        while (matcher.find()) {
            String digits = matcher.group();
            for (int i = 0; i < digits.length() - 2; ++i) {
                int a = digits.charAt(i) - 48;
                int b = digits.charAt(i + 1) - 48;
                int c = digits.charAt(i + 2) - 48;
                if ((b != a + 1 || c != b + 1) && (b != a - 1 || c != b - 1)) continue;
                return false;
            }
        }
        return true;
    }

    public static byte[] getBytes(String str) {
        if (str != null) {
            try {
                return str.getBytes(CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static boolean isIdIsNull(Long id) {
        return id == null || id.equals(0L);
    }

    public static String getStrByLength(String str, int length) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        if ((str = str.trim()).length() <= length) {
            return str;
        }
        return str.substring(0, length) + "\u2026\u2026";
    }

    public static boolean isLong(String str) {
        if (str == null) {
            return false;
        }
        try {
            Long.valueOf(str.trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        try {
            Integer.valueOf(str.trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        try {
            Double.valueOf(str.trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean checkEmail(String value) {
        return value != null && !"".equals(value) && value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    }

    public static boolean checkTel(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{4}-\\d{8}|\\d{4}-\\d{7}|\\d(3)-\\d(8)");
    }

    public static boolean checkMobile(String value) {
        return value != null && !"".equals(value) && value.matches("^[1][0-9]+\\d{9}");
    }

    public static boolean checkChineseName(String value, int length) {
        return value != null && !"".equals(value) && value.matches("^[\u4e00-\u9fa5]+\\{1}") && value.length() <= length;
    }

    public static boolean checkPhoneNumber(String phoneNumber) {
        String pattern = "^(86)?1[3-9]\\d{9}$";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(phoneNumber);
        return m.matches();
    }

    public static boolean checkBlank(String value) {
        return value != null && !"".equals(value) && value.matches("^\\s*|\\s*\\{1}");
    }

    public static boolean checkHtmlTag(String value) {
        return value != null && !"".equals(value) && value.matches("<(\\S*?)[^>]*>.*?</\\1>|<.*? />");
    }

    public static boolean checkURL(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-z]+://[^\\s]*");
    }

    public static boolean checkIP(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}");
    }

    public static boolean checkQQ(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9][0-9]{4,13}");
    }

    public static boolean checkPostCode(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9]\\d{5}(?!\\d)");
    }

    public static boolean checkIDCard(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{15}|\\d{18}|(^\\d{17}(\\d|X|x)$)");
    }

    public static boolean checkLength(String value, int length) {
        return (value == null || "".equals(value.trim()) ? 0 : value.length()) <= length;
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static boolean inString(String str, String ... strs) {
        if (str != null) {
            for (String s : strs) {
                if (!str.equals(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String replaceHtml(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static String replaceMobileHtml(String html) {
        if (html == null) {
            return "";
        }
        return html.replaceAll("<([a-z]+?)\\s+?.*?>", "<$1>");
    }

    public static Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(StringUtils.toDouble(val).floatValue());
    }

    public static Long toLong(Object val) {
        if (val == null) {
            return 0L;
        }
        try {
            return Long.valueOf(StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Integer toInteger(Object val) {
        return StringUtils.toLong(val).intValue();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String remoteAddr = request.getHeader("X-Real-IP");
        if (StringUtils.isNotBlank((CharSequence)remoteAddr)) {
            remoteAddr = request.getHeader("X-Forwarded-For");
        } else if (StringUtils.isNotBlank((CharSequence)remoteAddr)) {
            remoteAddr = request.getHeader("Proxy-Client-IP");
        } else if (StringUtils.isNotBlank((CharSequence)remoteAddr)) {
            remoteAddr = request.getHeader("WL-Proxy-Client-IP");
        }
        return remoteAddr != null ? remoteAddr : request.getRemoteAddr();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = StringUtils.toCamelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String toUnderScoreCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static void setValueIfNotBlank(String target, String source) {
        if (StringUtils.isNotBlank((CharSequence)source)) {
            target = source;
        }
    }

    public static String jsGetVal(String objectString) {
        StringBuilder result = new StringBuilder();
        StringBuilder val = new StringBuilder();
        String[] vals = StringUtils.split((String)objectString, (String)".");
        for (int i = 0; i < vals.length; ++i) {
            val.append("." + vals[i]);
            result.append("!" + val.substring(1) + "?'':");
        }
        result.append(val.substring(1));
        return result.toString();
    }

    public static boolean isNotEmpty(String str) {
        if (str == null) {
            return false;
        }
        return !(str = str.trim()).equals("");
    }

    public static List<Integer> parseToIntegerList(String str, String spliter) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (StringUtils.isNotEmpty(str)) {
            String[] arr;
            for (String a : arr = str.split(spliter)) {
                if (StringUtils.isBlank((CharSequence)a)) continue;
                intList.add(Integer.parseInt(a));
            }
        }
        return intList;
    }

    public static List<Long> parseToLongList(String str, String spliter) {
        ArrayList<Long> longList = new ArrayList<Long>();
        if (StringUtils.isNotEmpty(str)) {
            String[] arr;
            for (String a : arr = str.split(spliter)) {
                if (StringUtils.isBlank((CharSequence)a)) continue;
                longList.add(Long.parseLong(a));
            }
        }
        return longList;
    }

    public static List<Integer> parseStringToIntegerListIncludeNull(String str, String spliter) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (StringUtils.isNotEmpty(str)) {
            String[] arr;
            for (String a : arr = str.split(spliter)) {
                if (StringUtils.isNotEmpty(a)) {
                    intList.add(Integer.parseInt(a));
                    continue;
                }
                intList.add(null);
            }
        }
        return intList;
    }

    public static int getStringLength(String str) {
        int len = 0;
        for (int i = 0; i < str.length(); ++i) {
            Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
            Matcher m = p.matcher(str);
            if (m.find()) {
                len += 2;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static String local2url(String filePath, String firstIndex) {
        Object webfilepath = "/" + filePath.substring(filePath.indexOf(firstIndex));
        try {
            webfilepath = ((String)webfilepath).replaceAll("\\\\", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webfilepath;
    }

    public static Boolean validContains(String values, String value, String separator) {
        if (StringUtils.isBlank((CharSequence)values) || StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        String[] valuesArray = StringUtils.split((String)values, (String)separator);
        if (valuesArray != null) {
            for (String v : valuesArray) {
                if (!value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getOrderByStr(String columName, String orderType, boolean isOerderByPinYin) {
        if (isOerderByPinYin) {
            return "CONVERT( " + columName + " USING gbk ) COLLATE gbk_chinese_ci " + orderType;
        }
        return columName + " " + orderType;
    }

    public static String[] splitByWaveLine(String str) {
        String[] strs = new String[]{"", ""};
        if (!StringUtils.isBlank((CharSequence)str)) {
            if (str.contains("~")) {
                strs = str.split("~");
            } else if (str.contains("\uff5e")) {
                strs = str.split("\uff5e");
            } else {
                strs[0] = str;
                strs[1] = str;
            }
        }
        return strs;
    }

    public static String[] splitByLt(String str) {
        String[] strs = new String[]{"", ""};
        if (!StringUtils.isBlank((CharSequence)str)) {
            if (str.contains("\uff1c")) {
                strs = str.split("\uff1c");
            } else {
                strs[0] = str;
                strs[1] = str;
            }
        }
        return strs;
    }

    public static String[] splitByLte(String str) {
        String[] strs = new String[]{"", ""};
        if (!StringUtils.isBlank((CharSequence)str)) {
            if (str.contains("\u2264")) {
                strs = str.split("\u2264");
            } else {
                strs[0] = str;
                strs[1] = str;
            }
        }
        return strs;
    }

    public static String convertArrayToString(String[] array, String spliter) {
        Object ids = "";
        if (array != null && array.length > 0) {
            for (String id : array) {
                ids = (String)ids + id + ",";
            }
            ids = ((String)ids).substring(0, ((String)ids).length() - 1);
        }
        return ids;
    }

    public static String[] getNumAndChinese(String str) {
        String[] strs = new String[]{"0", ""};
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]+|\\d+");
        Matcher m = p.matcher(str);
        int i = 0;
        while (m.find()) {
            strs[i] = m.group();
            if (!StringUtils.isNumber(strs[0])) {
                strs[0] = "0";
                break;
            }
            if (i == 2) break;
            ++i;
        }
        return strs;
    }

    public static String getFileNameStr(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return "";
        }
        fileName = fileName.replace("/", "#");
        fileName = fileName.replace("\\", "#");
        fileName = fileName.replace(":", "#");
        fileName = fileName.replace("*", "#");
        fileName = fileName.replace("?", "#");
        fileName = fileName.replace("<", "#");
        fileName = fileName.replace(">", "#");
        fileName = fileName.replace("?", "#");
        return fileName;
    }

    public static String b2mb(long filesize) {
        double r = 0.0;
        String sbyte = "";
        if (filesize > 0x10000000000L) {
            sbyte = "T";
            r = Math.round(filesize / 1024L / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x4B400000L) {
            sbyte = "G";
            r = Math.round(filesize / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x100000L) {
            sbyte = "M";
            r = Math.round(filesize / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 1024L) {
            sbyte = "K";
            r = Math.round(filesize / 1024L * 10L) / 10;
        } else {
            sbyte = "";
            r = filesize;
        }
        return r + sbyte;
    }

    public static String getWebFullPath(HttpServletRequest request) {
        String path = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
        return path;
    }

    public static int getAreaLevel(Long areaId) {
        if (areaId == null) {
            return 0;
        }
        if (areaId == 0L) {
            return 0;
        }
        return areaId == areaId / 10000000000L * 10000000000L ? 1 : (areaId == areaId / 100000000L * 100000000L ? 2 : (areaId == areaId / 1000000L * 1000000L ? 3 : (areaId == areaId / 100L * 100L ? 4 : 5)));
    }

    public static int getAreaLevel(String areaIdStr) {
        Long areaId;
        try {
            areaId = Long.parseLong(areaIdStr);
        }
        catch (NumberFormatException e) {
            log.error("Exception\uff1a", (Throwable)e);
            return 0;
        }
        return StringUtils.getAreaLevel(areaId);
    }

    public static String toChinese(String str) {
        String[] s1 = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] s2 = new String[]{"\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343"};
        Object result = "";
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            result = i != n - 1 && num != 0 ? (String)result + s1[num] + s2[n - 2 - i] : (String)result + s1[num];
        }
        String res = ((String)result).replace("\u4e00\u5341", "\u5341");
        return res;
    }

    public static String toChinese2(String str) {
        String[] s2 = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        StringBuffer sb = new StringBuffer();
        for (char c : str.toCharArray()) {
            sb.append(s2[Integer.parseInt(String.valueOf(c))]);
        }
        return sb.toString();
    }

    public static String generateUsername(String prefix) {
        String username = (StringUtils.isBlank((CharSequence)prefix) ? "user_" : prefix) + "_" + System.currentTimeMillis();
        return username;
    }

    public static String generateUsername() {
        String username = "user_" + System.currentTimeMillis();
        return username;
    }

    public static String getLastPlanName() {
        return "\u7b2c" + StringUtils.toChinese(String.valueOf(StringUtils.getPlanNum(LocalDate.now().getYear()) - 1)) + "\u4e2a\u4e94\u5e74\u8ba1\u5212";
    }

    public static Integer getPlanNum(int currentYear) {
        if (currentYear < 1966) {
            return -1;
        }
        int planNum = (currentYear - 1966) / 5 + 3;
        return planNum;
    }

    public static Integer getPlanEndYear(int year) {
        return year - StringUtils.getPlanSection(year) + 5;
    }

    public static Integer getPlanSection(int currentYear) {
        if (currentYear < 1966) {
            return -1;
        }
        return (currentYear - 1966) % 5 + 1;
    }

    public static Integer getLastPlanEndYear() {
        int year = LocalDate.now().getYear();
        return year - StringUtils.getPlanSection(year);
    }

    public static String getRandomNum(int length) {
        String baseNums = "0123456789";
        return StringUtils.getRandomStr(length, baseNums);
    }

    private static String getRandomStr(int len, String base) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return !StringUtils.isNull(object);
    }

    public static String getGenderByIdCard(String idNumber) {
        if (idNumber == null) {
            return null;
        }
        int gender = 0;
        if (idNumber.length() == 18) {
            char c = idNumber.charAt(idNumber.length() - 2);
            gender = Integer.parseInt(String.valueOf(c));
        } else {
            char c = idNumber.charAt(idNumber.length() - 1);
            gender = Integer.parseInt(String.valueOf(c));
        }
        if (gender % 2 == 1) {
            return "\u7537";
        }
        return "\u5973";
    }
}

