/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.core.framework.utils;

import cn.smarthse.rho.core.framework.model.LayuiGridData;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyExcelUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EasyExcelUtil.class);

    public static void exportDynamicExcel(List<String> includeColumnFiledNames, String fileName, Class<?> clazz, HttpServletResponse response, Supplier<LayuiGridData<?>> supplier) {
        ExcelWriter excelWriter = null;
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String encodeFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename=" + encodeFileName + ".xlsx");
            ExcelWriterBuilder excelBuilder = EasyExcel.write((OutputStream)outputStream, clazz);
            EasyExcelUtil.includeColumnFiledName(includeColumnFiledNames, excelBuilder);
            excelWriter = excelBuilder.build();
            EasyExcelUtil.export(excelWriter, supplier);
        }
        catch (IOException e) {
            log.error("\u5206\u9875\u5bfc\u51faExcel\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("Excel\u5bfc\u51fa\u5931\u8d25", e);
        }
        finally {
            if (excelWriter != null) {
                try {
                    excelWriter.close();
                }
                catch (Exception e) {
                    log.error("Excel writer close failed", (Throwable)e);
                }
            }
        }
    }

    public static void exportDynamicExcel(List<String> includeColumnFiledNames, String fileName, List<?> list, Class<?> clazz, HttpServletResponse response) {
        try {
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            String encodeFileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename=" + encodeFileName + ".xlsx");
            ExcelWriterBuilder excelBuilder = EasyExcel.write((OutputStream)os, clazz);
            excelBuilder = EasyExcelUtil.includeColumnFiledName(includeColumnFiledNames, excelBuilder);
            ((ExcelWriterBuilder)excelBuilder.useDefaultStyle(Boolean.valueOf(false))).sheet("Sheet1").doWrite(list);
            os.close();
        }
        catch (IOException e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38", (Throwable)e);
        }
    }

    private static ExcelWriterBuilder includeColumnFiledName(List<String> includeColumnFieldNames, ExcelWriterBuilder excelBuilder) {
        excelBuilder = (ExcelWriterBuilder)excelBuilder.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
        if (!includeColumnFieldNames.isEmpty()) {
            excelBuilder = (ExcelWriterBuilder)excelBuilder.includeColumnFieldNames(includeColumnFieldNames);
        }
        return excelBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(ExcelWriter excelWriter, Supplier<LayuiGridData<?>> supplier) {
        long page = 1L;
        try {
            LayuiGridData<?> res;
            long pages;
            do {
                res = supplier.get();
                excelWriter.write(res.getData(), EasyExcel.writerSheet((String)"Sheet1").build());
            } while (++page <= (pages = res.getPages()));
        }
        finally {
            if (excelWriter != null) {
                try {
                    excelWriter.finish();
                }
                catch (Exception e) {
                    log.error("Excel writer finish failed", (Throwable)e);
                }
            }
        }
    }
}

