/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.core.framework.mybatis;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.mybatisPlus.config.properties.DataChangeRecorderProperties;
import cn.smarthse.framework.mybatisPlus.plugins.inner.DataChangeRecorderInnerInterceptor;
import cn.smarthse.framework.mybatisPlus.service.DataChangeRecorderService;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.filter.dubbo.RhoUserInfoHolder;
import cn.smarthse.rho.core.framework.mybatis.DataChangeRecordMapper;
import cn.smarthse.rho.core.framework.mybatis.SysChangeLog;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeRecorderServiceImpl
implements DataChangeRecorderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataChangeRecorderServiceImpl.class);
    private final String delColumn;
    private final Map<String, Map<String, String>> tableColumnMap;
    private DataChangeRecordMapper dataChangeRecordMapper;

    public DataChangeRecorderServiceImpl(DataChangeRecorderProperties dataChangeRecorderProperties) {
        this.delColumn = dataChangeRecorderProperties.getDelColumn();
        this.tableColumnMap = dataChangeRecorderProperties.getTableColumnMap();
    }

    public List<?> convertToLogs(DataChangeRecorderInnerInterceptor.OperationResult operationResult) {
        JSONArray array;
        String changedData = operationResult.getChangedData();
        if (StringUtils.isBlank((CharSequence)changedData)) {
            return Collections.emptyList();
        }
        try {
            array = JSON.parseArray((String)changedData);
        }
        catch (JSONException e) {
            log.error("JSON parse error, changedData={}", (Object)changedData, (Object)e);
            return Collections.emptyList();
        }
        if (CollUtil.isEmpty((Collection)array)) {
            return Collections.emptyList();
        }
        Map<String, String> columnMap = this.tableColumnMap.get(operationResult.getTableName());
        if (MapUtil.isEmpty(columnMap)) {
            return Collections.emptyList();
        }
        LocalDateTime now = LocalDateTime.now();
        RhoUserInfoHolder holder = RhoUserInfoHolder.getCurrentUser();
        String keyColumn = operationResult.getKeyColumn();
        String upperKeyColumn = keyColumn.toUpperCase();
        String operation = operationResult.getOperation();
        boolean isInsert = DataChangeRecorderProperties.OperationType.INSERT.name().equalsIgnoreCase(operation);
        ArrayList<SysChangeLog> logList = new ArrayList<SysChangeLog>(array.size() * columnMap.size());
        for (Object o : array) {
            Long dataId;
            JSONObject jsonObject = (JSONObject)o;
            String id = jsonObject.getString(upperKeyColumn);
            if (StringUtils.isBlank((CharSequence)id)) continue;
            if (isInsert) {
                String[] contentSplit = id.split("->");
                dataId = Convert.toLong((Object)contentSplit[1]);
                if (Objects.isNull(dataId)) {
                    continue;
                }
            } else {
                dataId = Convert.toLong((Object)id);
            }
            long batchCode = Instant.now().toEpochMilli();
            for (String colomn : jsonObject.keySet()) {
                if (colomn.toUpperCase().equals(upperKeyColumn)) continue;
                SysChangeLog log = new SysChangeLog();
                log.setBatchCode(batchCode);
                log.setTableName(operationResult.getTableName());
                log.setDataId(dataId);
                log.setFieldName(columnMap.get(colomn.toLowerCase()));
                log.setFieldValue(colomn.toLowerCase());
                String content = jsonObject.getString(colomn);
                String[] contentSplit = content.split("->");
                log.setBeforeValue(contentSplit.length >= 1 ? contentSplit[0] : null);
                log.setAfterValue(contentSplit.length >= 2 ? contentSplit[1] : null);
                log.setCid(holder.getOidOrCid());
                log.setUserId(holder.getUserId());
                log.setUsername(holder.getUserName());
                log.setOperation(colomn.equalsIgnoreCase(this.delColumn) ? "delete" : operationResult.getOperation());
                log.setEditTime(now);
                log.setContent(content);
                log.setCreateBy(log.getUserId());
                log.setCreateDate(now);
                log.setIsValid(Constant.ACTIVE_YES);
                logList.add(log);
            }
        }
        return logList;
    }

    public void saveBatch(List<?> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        this.getDataChangeRecordMapper().insert(logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataChangeRecordMapper getDataChangeRecordMapper() {
        if (!ObjectUtil.isNull((Object)this.dataChangeRecordMapper)) return this.dataChangeRecordMapper;
        Class<DataChangeRecorderInnerInterceptor> clazz = DataChangeRecorderInnerInterceptor.class;
        synchronized (DataChangeRecorderInnerInterceptor.class) {
            if (!ObjectUtil.isNull((Object)this.dataChangeRecordMapper)) return this.dataChangeRecordMapper;
            this.dataChangeRecordMapper = (DataChangeRecordMapper)SpringUtils.getBean(DataChangeRecordMapper.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dataChangeRecordMapper;
        }
    }
}

