/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.core.framework.filter.dubbo;

import cn.hutool.core.convert.Convert;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcServiceContext;

public class RhoUserInfoHolder
implements Serializable {
    private static final ThreadLocal<RhoUserInfoHolder> customUserContext = new ThreadLocal();
    public static final String oidorcid = "rho-oidOrCid";
    public static final String userid = "rho-userId";
    public static final String username = "rho-userName";
    private Long oidOrCid;
    private Long userId;
    private String userName;

    public static void setCustomUser(RhoUserInfoHolder user) {
        customUserContext.set(user);
    }

    public static void clearCustomUser() {
        customUserContext.remove();
    }

    public static RhoUserInfoHolder getCurrentUser() {
        RhoUserInfoHolder customUser = customUserContext.get();
        if (Objects.nonNull(customUser)) {
            return customUser;
        }
        RhoUserInfoHolder userInfo = new RhoUserInfoHolder();
        try {
            RpcServiceContext rpcContext = RpcContext.getServiceContext();
            String cidStr = rpcContext.getAttachment(oidorcid);
            String userIdStr = rpcContext.getAttachment(userid);
            String userName = rpcContext.getAttachment(username);
            userInfo.setOidOrCid(Convert.toLong((Object)cidStr));
            userInfo.setUserId(Convert.toLong((Object)userIdStr));
            userInfo.setUserName(userName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (userInfo.getOidOrCid() == null) {
            userInfo.setOidOrCid(ShiroCommonUtil.getJWTOidOrCid());
        }
        if (userInfo.getUserId() == null) {
            userInfo.setUserId(ShiroCommonUtil.getJWTUserId());
        }
        if (userInfo.getUserName() == null) {
            userInfo.setUserName(ShiroCommonUtil.getJWTUsername());
        }
        return userInfo;
    }

    @Generated
    public RhoUserInfoHolder() {
    }

    @Generated
    public Long getOidOrCid() {
        return this.oidOrCid;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public void setOidOrCid(Long oidOrCid) {
        this.oidOrCid = oidOrCid;
    }

    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RhoUserInfoHolder)) {
            return false;
        }
        RhoUserInfoHolder other = (RhoUserInfoHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$oidOrCid = this.getOidOrCid();
        Long other$oidOrCid = other.getOidOrCid();
        if (this$oidOrCid == null ? other$oidOrCid != null : !((Object)this$oidOrCid).equals(other$oidOrCid)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RhoUserInfoHolder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $oidOrCid = this.getOidOrCid();
        result = result * 59 + ($oidOrCid == null ? 43 : ((Object)$oidOrCid).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RhoUserInfoHolder(oidOrCid=" + this.getOidOrCid() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ")";
    }
}

