/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.core.framework;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.rho.core.framework.LoginUser;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroCommonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShiroCommonUtil.class);
    public static final String USERTYPE_SUPERVISE_KEY = "supervise";
    public static final String USERTYPE_COMPANY_KEY = "company";
    public static final String LOGIN_USER_KEY = "loginUser";
    public static final String USER_TYPE_KEY = "userType";
    public static final String LOGIN_METHOD_KEY = "loginMethod";
    public static final String USERID_KEY = "userId";
    public static final String USERNAME_KEY = "username";
    public static final String FULL_NAME_KEY = "fullName";
    public static final String OID_CID_KEY = "oidOrCid";
    public static final String AREA_ID_KEY = "areaId";
    public static final String AREA_LEVEL_KEY = "areaLevel";
    public static final String IS_TEST_KEY = "isTest";

    public static String getRandomString() {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            int number = ThreadLocalRandom.current().nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static void login(LoginUser loginUser, SaLoginParameter model) {
        model = (SaLoginParameter)ObjectUtil.defaultIfNull((Object)model, (Object)new SaLoginParameter());
        StpUtil.login((Object)loginUser.getLoginId(), (SaLoginParameter)model.setIsConcurrent(Boolean.valueOf(ShiroCommonUtil.isMultiLoginAccount(loginUser.getUsername()))).setExtra(USER_TYPE_KEY, (Object)loginUser.getUserType()).setExtra(LOGIN_METHOD_KEY, (Object)loginUser.getLoginMethod()).setExtra(USERID_KEY, (Object)loginUser.getId()).setExtra(USERNAME_KEY, (Object)loginUser.getUsername()).setExtra(FULL_NAME_KEY, (Object)loginUser.getFullName()).setExtra(OID_CID_KEY, (Object)loginUser.getOidOrcid()).setExtra(AREA_ID_KEY, (Object)loginUser.getAreaId()).setExtra(AREA_LEVEL_KEY, (Object)loginUser.getAreaLevel()).setExtra(IS_TEST_KEY, (Object)loginUser.getIsTest()));
        StpUtil.getTokenSession().set(LOGIN_USER_KEY, (Object)loginUser);
    }

    public static <T extends LoginUser> T getShiroPrincipal() {
        SaSession session = StpUtil.getTokenSession();
        if (ObjectUtil.isNull((Object)session)) {
            return null;
        }
        return (T)((LoginUser)session.get(LOGIN_USER_KEY));
    }

    public static <T extends LoginUser> T getShiroPrincipal(String token) {
        SaSession session;
        if (SaFoxUtil.isEmpty((Object)token)) {
            return null;
        }
        String tokenPrefix = SaManager.getConfig().getTokenPrefix();
        if (SaFoxUtil.isNotEmpty((Object)tokenPrefix)) {
            if (!token.startsWith(tokenPrefix + " ")) {
                throw NotLoginException.newInstance((String)StpUtil.stpLogic.loginType, (String)"-7", (String)("\u672a\u6309\u7167\u6307\u5b9a\u524d\u7f00\u63d0\u4ea4 token\uff0cprefix=" + tokenPrefix), null).setCode(11017);
            }
            token = token.substring(tokenPrefix.length() + " ".length());
        }
        if (ObjectUtil.isNull((Object)(session = StpUtil.getTokenSessionByToken((String)token)))) {
            return null;
        }
        return (T)((LoginUser)session.get(LOGIN_USER_KEY));
    }

    public static Object getLoginId(String userType, Long userId) {
        if (userType == null) {
            throw new IllegalArgumentException("\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (userId == null) {
            throw new IllegalArgumentException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return userType + ":" + userId;
    }

    private static Object getExtra(String key) {
        try {
            return StpUtil.getExtra((String)key);
        }
        catch (ApiDisabledException e) {
            log.error("\u83b7\u53d6JWT\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getJWTUserType() {
        return Convert.toLong((Object)ShiroCommonUtil.getExtra(USER_TYPE_KEY));
    }

    public static Long getJWTLoginMethod() {
        return Convert.toLong((Object)ShiroCommonUtil.getExtra(LOGIN_METHOD_KEY));
    }

    public static Long getJWTUserId() {
        return Convert.toLong((Object)ShiroCommonUtil.getExtra(USERID_KEY));
    }

    public static String getJWTUsername() {
        return Convert.toStr((Object)ShiroCommonUtil.getExtra(USERNAME_KEY));
    }

    public static String getJWTFullName() {
        return Convert.toStr((Object)ShiroCommonUtil.getExtra(FULL_NAME_KEY));
    }

    public static Long getJWTOidOrCid() {
        return Convert.toLong((Object)ShiroCommonUtil.getExtra(OID_CID_KEY));
    }

    public static Long getJWTAreaId() {
        return Convert.toLong((Object)ShiroCommonUtil.getExtra(AREA_ID_KEY));
    }

    public static Byte getJWTAreaLevel() {
        return Convert.toByte((Object)ShiroCommonUtil.getExtra(AREA_LEVEL_KEY));
    }

    public static Integer getJWTIsTest() {
        return Convert.toInt((Object)ShiroCommonUtil.getExtra(IS_TEST_KEY));
    }

    public static boolean isMultiLoginAccount(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return SaManager.getConfig().getIsConcurrent();
        }
        String specifiedUserName = ((SysProperties)SpringUtils.getBean(SysProperties.class)).getLogin().getMultiLoginAccount();
        if (StringUtils.isEmpty((String)specifiedUserName)) {
            return SaManager.getConfig().getIsConcurrent();
        }
        String upperUsername = username.toUpperCase();
        String upperSpecifiedUserName = specifiedUserName.toUpperCase();
        String[] unameArr = upperSpecifiedUserName.split(",");
        return Arrays.asList(unameArr).contains(upperUsername);
    }
}

