package cn.smarthse.rho.core.framework.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import lombok.extern.slf4j.Slf4j;

import java.net.HttpURLConnection;

/**
 * @ClassName VideoUtils
 * @Description 视频工具类
 * @Author ChenLiang
 * @ModifyDate 2022/3/30 16:37
 */
@Slf4j
public class VideoUtils {
    /**
     * 比较时长，
     *
     * @param d1 例如 10:20:50
     * @param d2 例如 10:20:50
     * @return d1 >= d2
     */
    public static boolean compareDuration(String d1, String d2) {
        return duration2Second(d1) >= duration2Second(d2);
    }

    /**
     * 时长转秒
     * @param d 例如 10:20:50
     * @return
     */
    public static Long duration2Second(String d){
        String[] split = d.split(":");
        if(split.length > 3){
            throw new RuntimeException("时长异常");
        }
        Long second = 0L;
        Long base = 1L;

        for (int i = split.length - 1; i >= 0; i--) {
            second += Long.valueOf(split[i])*base;
            base = base * 60;
        }
        return second;
    }

    /**
     * 验证图片是否有效
     * @param imgUrl
     * @return
     */

    public static Boolean isImagesTrue(String imgUrl) {

        Integer RESPONSE_CODE = 0;
        try {
            HttpRequest request = HttpUtil.createGet(imgUrl);
            HttpResponse execute = request.execute();
            RESPONSE_CODE = execute.getStatus();
        } catch (Exception e) {
           return false;
        }

        return RESPONSE_CODE == HttpURLConnection.HTTP_OK;
    }
}
