package cn.smarthse.rho.core.framework.utils;

import java.math.BigDecimal;

public class NumberUtil extends cn.hutool.core.util.NumberUtil {

    /**
     * @param v1
     * @param v2
     * @return {@link BigDecimal} 85.25
     */
    public static BigDecimal customDivReturnBigDecimal(Integer v1, Integer v2) {

        return customDivReturnBigDecimal(v1, v2, 4);
    }

    public static BigDecimal customDivReturnBigDecimal(Integer v1, Integer v2, int scale) {

        if (v2 == null || v2 == 0) return null;

        if (v1 == null || v1 == 0) return new BigDecimal("0.00");

        return div(v1, v2, scale).movePointRight(2);
    }

    /**
     * @param v1
     * @param v2
     * @return {@link String} 85.25%
     */
    public static String customDivReturnString(Integer v1, Integer v2) {

        return customDivReturnString(v1, v2, 4);
    }

    public static String customDivReturnString(Integer v1, Integer v2, int scale) {

        if (v2 == null || v2 == 0) return "-";

        if (v1 == null || v1 == 0) return "0.00%";

        return NumberUtil.formatPercent(NumberUtil.div(v1, v2, scale).doubleValue(), scale);
    }

    public static void main(String[] args) {
        System.out.println(customDivReturnBigDecimal(1, 3));
        System.out.println(customDivReturnString(1, 3));
    }

}
