package cn.smarthse.rho.core.framework.utils;

import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 *
 * ip工具类
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/5/19 14:46
 */
@Slf4j
public class IpUtil {

    private static final String LOCALHOST = "127.0.0.1";

    /**
     * 判断ip是否在指定网段
     * @param ip ip地址
     * @param ipAreaList ip网段集合 eg: 42.120.174.0/29
     */
    public static boolean ipIsInNet(String ip, List<String> ipAreaList) {

        for (String ipArea : ipAreaList) {
            if (ipIsInNet(ip, ipArea)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断ip是否在指定网段
     * @param ip ip地址
     * @param ipArea ip网段 eg: 42.120.174.0/29
     */
    public static boolean ipIsInNet(String ip, String ipArea) {

        if (LOCALHOST.equals(ip)) {
            return true;
        }

        if(StringUtils.isBlank(ipArea) || StringUtils.isBlank(ip)){
            return false;
        }

        String[] ipArray = ipArea.split(",");
        try {
            for (String s : ipArray) {
                if (!s.contains("/")) {
                    if (s.equals(ip)) {
                        return true;
                    }
                    continue;
                }

                String[] ips = ip.split("\\.");
                //ip地址的十进制值
                int ipAddress = (Integer.parseInt(ips[0]) << 24)
                        | (Integer.parseInt(ips[1]) << 16)
                        | (Integer.parseInt(ips[2]) << 8) | Integer.parseInt(ips[3]);
                //掩码（0-32）
                int type = Integer.parseInt(s.replaceAll(".*/", ""));
                //匹配的位数为32 - type位（16进制的1）
                int mask = 0xFFFFFFFF << (32 - type);
                String cidrIp = s.replaceAll("/.*", "");
                //网段ip十进制
                String[] cidrIps = cidrIp.split("\\.");
                int cidrIpAddr = (Integer.parseInt(cidrIps[0]) << 24)
                        | (Integer.parseInt(cidrIps[1]) << 16)
                        | (Integer.parseInt(cidrIps[2]) << 8)
                        | Integer.parseInt(cidrIps[3]);

                if((ipAddress & mask) == (cidrIpAddr & mask)){
                    return true;
                }
            }
        } catch (NumberFormatException e) {
            log.error("Exception：", e);
            return false;
        }
        return false;
    }



//    public static void main(String[] args) {
//        System.out.println(ipIsInNet("60.191.28.82","123.0.28.0/24,42.120.174.0/23,60.191.28.82"));
//        System.out.println(ipIsInNet("42.120.174.23","42.120.174.0/29"));
//    }
}
