package cn.smarthse.rho.core.framework.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.smarthse.rho.core.framework.Constant;

import java.util.concurrent.ThreadLocalRandom;

/**
 * @author lixiao
 * @date 2019/7/31 17:11
 */
public class CommonsUtils {

    /**
     * 获取六位数验证码
     *
     * @return 验证码
     */
    public static int getCode() {
        return ThreadLocalRandom.current().nextInt(100000, 999999);
    }

    /**
     * 使用SHA256加密
     *
     * @param password 需要加密的密码 md5 32位小写
     * @param salt     盐值
     * @return 返回加密后的密码
     */
    public static String encryptPassword(String password, String salt) {
        byte[] bytes = DigestUtil.sha256(salt + password);
        for (int i = 1; i < Constant.Password.HASH_ITERATIONS; i++) {
            bytes = DigestUtil.sha256(bytes);
        }
        return HexUtil.encodeHexStr(bytes);
    }

    private static final Integer NAME_MAX_LENGTH = 100;

    /**
     * 校验联系人姓名
     *
     * @param name 姓名
     * @return true 合法，false 不合法
     */
    public static boolean isValidBindName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.length() < 2 || name.length() > NAME_MAX_LENGTH) {
            return false;
        }
        // 正则：只允许中文或英文，不允许数字、特殊符号、中间空格
        String regex = "^[\\u4e00-\\u9fa5A-Za-z]+$";
        return name.matches(regex);
    }
}
