package cn.smarthse.rho.core.framework.model;

import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * 操作账号信息（编辑数据接口的参数类可继承此类）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/11 15:33
 */
@Data
public class UserEditParam implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /*
     操作账号id
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Long loginUserId;

    /*
    操作账号昵称
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private String loginName;

    /*
    操作账号名称
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private String loginUsername;

    /*
     操作账号行政区划id
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Long loginAreaId;

    /*
     操作账号行政区划level
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Integer loginAreaLevel;

    /*
    操作账号用户类型
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Integer loginUserType;

    /*
    操作账号的单位cid或oid
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Long loginCid;

    /*
     操作账号是否线上特殊账号,适用于监管
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Boolean isOnlineSpecialTestUser;

    /*
     * 新增的时候校验分组
     */
    public interface Add {
    }

    /*
     * 更新的时候校验分组
     */
    public interface Update {
    }

}
