package cn.smarthse.rho.core.framework.model;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import com.alibaba.fastjson2.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.util.Date;

/**
 * 基础查询参数对象
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PageParam extends LayuiGridParam {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 查询关键字
     */
    private String keyword;

    /*
    查询关键字[加密]
     */
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    @JsonIgnore
    @JSONField(serialize = false)
    private String keywordEn;

    /**
     * 查询开始日期
     */
    private Date beginDate;

    /**
     * 查询结束日期
     */
    private Date endDate;

    /**
     * 查询单位cid或oid
     */
    private Long cid;

    /**
     * 查询行政区划id
     */
    private Long areaId;
    /*
    查询行政区划level
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Integer level;

    /**
     * 查询年份
     */
    private Integer years;

    /**
     * 查询是否本级
     * null：全部
     * 1：仅显示本级
     * 2：仅显示非本级
     */
    private Integer onlyThisLevel;
    /*
     * CompanyBelongTypeEnum
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Integer belongType;

    /**
     * 查询是否是测试
     */
    private Integer isTest;

    public void setKeyword(String keyword) {
        this.keyword = (keyword == null ? null : keyword.trim());
    }

}
