
package cn.smarthse.rho.core.framework.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * layui 分页参数
 * 网址：https://www.layui.com/demo/table.html
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年9月23日 下午4:21:01
 */
@EqualsAndHashCode(callSuper = true)
public @Data class LayuiGridParam extends UserEditParam {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 页码
     */
    private int page;

    /**
     * 每页几条记录
     */
    private int limit;

    /**
     * 用于排序的列名
     */
    private String sidx;

    /**
     * 排序的方式 asc desc
     */
    private String sord;

    /**
     * 是否进行count查询
     */
    private Boolean count;

    public LayuiGridParam() {
        this.page = 1;
        this.limit = 10;
        this.count = true;
    }

}
