package cn.smarthse.rho.core.framework.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.util.StringUtils;

import java.io.Serial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 带表头的分页查询参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2024/6/7 13:37
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class HeadPageParam extends PageParam {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 表头eg：姓名|name,性别|sex,账号|username,手机号|mobile,状态|isForbidenStr
     */
    private List<String> headList;

    /**
     * 获取表头字段编码 eg：name,sex,username,mobile,isForbidenStr
     *
     * @return {@link List<String>}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/6/7 14:40
     */
    public List<String> headField() {
        //处理headList，去掉中文，保留编码
        List<String> headField = new ArrayList<>();
        if (headList != null) {
            headList.forEach(h -> {
                int beginIndex = h.indexOf("|");
                if (beginIndex != -1) {
                    headField.add(h.substring(beginIndex + 1));
                } else {
                    headField.add(h);
                }
            });
        }
        return headField;
    }


    /**
     * 表头eg：name,sex,username,mobile
     */
    private String headStr;

    /**
     * 将表头字段转换为list
     * @author chuhy
     * @date 2025/8/29 9:53
     */
    public List<String> headStrField() {
        //处理headStr，根据英文逗号分割，添加到list中
        List<String> headField = new ArrayList<>();
        if (StringUtils.hasLength(headStr)) {
            headField.addAll(Arrays.asList(headStr.split(",")));
        }
        return headField;
    }
}
