package cn.smarthse.rho.core.framework.filter.dubbo;

import cn.hutool.core.convert.Convert;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import lombok.Data;
import org.apache.dubbo.rpc.RpcContext;

import java.io.Serializable;
import java.util.Objects;

@Data
public class RhoUserInfoHolder implements Serializable {

    private static final ThreadLocal<RhoUserInfoHolder> customUserContext = new ThreadLocal<>();

    /**
     * 设置自定义用户信息（用于定时任务等场景）
     */
    public static void setCustomUser(RhoUserInfoHolder user) {
        customUserContext.set(user);
    }

    /**
     * 清除自定义用户信息
     */
    public static void clearCustomUser() {
        customUserContext.remove();
    }

    public static final String oidorcid = "rho-oidOrCid";
    public static final String userid = "rho-userId";
    public static final String username = "rho-userName";

    private Long oidOrCid;

    private Long userId;

    private String userName;

    public static RhoUserInfoHolder getCurrentUser() {

        RhoUserInfoHolder customUser = customUserContext.get();
        if (Objects.nonNull(customUser)) {
            return customUser;
        }

        RhoUserInfoHolder userInfo = new RhoUserInfoHolder();
        try {
            RpcContext rpcContext = RpcContext.getServiceContext();
            String cidStr = rpcContext.getAttachment(oidorcid);
            String userIdStr = rpcContext.getAttachment(userid);
            String userName = rpcContext.getAttachment(username);

            userInfo.setOidOrCid(Convert.toLong(cidStr));
            userInfo.setUserId(Convert.toLong(userIdStr));
            userInfo.setUserName(userName);
        } catch (Exception ignored) {

        }

        if (userInfo.getOidOrCid() == null) {
            userInfo.setOidOrCid(ShiroCommonUtil.getJWTOidOrCid());
        }
        if (userInfo.getUserId() == null) {
            userInfo.setUserId(ShiroCommonUtil.getJWTUserId());
        }
        if (userInfo.getUserName() == null) {
            userInfo.setUserName(ShiroCommonUtil.getJWTUsername());
        }

        return userInfo;
    }

}