package cn.smarthse.rho.core.framework.filter.dubbo;

import cn.smarthse.rho.core.framework.Constant;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.rpc.*;
import org.slf4j.MDC;

/**
 * dubbo拦截，提供端调用时，从attachment中获取MDC信息、token信息，并存入MDC
 * 1. dubbo.consumer.filter: ConsumerMdcFilter
 * 2. META-INF/dubbo/org.apache.dubbo.rpc.Filter 文件内容：ConsumerMdcFilter=cn.smarthse.xxx.modules.wx.bootstrap.filter.ConsumerMdcFilter
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/8/10 17:16
 */
@Slf4j
public class ProviderMdcFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        MDC.put(Constant.trackId, invocation.getAttachment("trackId"));

        try {
            return invoker.invoke(invocation);
        } finally {
            MDC.clear();
        }
    }
}

