package cn.smarthse.rho.core.framework.constant;

import lombok.Getter;

/**
 * 登录验证状态枚举
 */
@Getter
public enum VerifySituationEnum {

    UNDEFINED(0, "未明确"),

    VERIFIED(1, "已验证"),

    PASSWORD_UNVERIFIED_NO_PHONE(2, "未验证，未绑定手机号"),

    PASSWORD_UNVERIFIED_WITH_PHONE(3, "未验证，已绑定手机号"),

    ZZD_UNVERIFIED_MULTIPLE_USERS(4, "未验证，但存在多个用户");

    private final int code;
    private final String description;

    VerifySituationEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据code获取枚举值
     *
     * @param code 状态码
     * @return 对应的枚举值，未找到则返回null
     */
    public static VerifySituationEnum fromCode(int code) {
        for (VerifySituationEnum status : VerifySituationEnum.values()) {
            if (status.getCode() == code) {
                return status;
            }
        }
        return null;
    }
}
