package cn.smarthse.rho.core.framework.constant;

import lombok.Getter;

/**
 * 登录方式枚举
 */
@Getter
public enum LoginMethodEnum {

    LOGIN_CAS(0, "单点登录"),

    LOGIN_USERNAME_PASSWORD(2, "用户密码登录"),

    LOGIN_ZZD(4, "浙政钉登录");

    private final Integer code;
    private final String description;

    LoginMethodEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static LoginMethodEnum fromCode(Integer code) {
        for (LoginMethodEnum type : values()) {
            if (type.code.equals(code)) {
                return type;
            }
        }
        return null;
    }
}
