package cn.smarthse.rho.core.framework.constant;

import lombok.Getter;

/**
 * 登录授权类型
 */
@Getter
public enum GrantTypeEnum {

    PASSWORD("password", "密码登录"),
    ZZD("zzd", "浙政钉登录"),
    CAS("cas", "CAS登录"),
    CID("cid", "CID登录"),
    ;

    private final String code;
    private final String description;

    GrantTypeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static GrantTypeEnum fromCode(String code) {
        for (GrantTypeEnum type : GrantTypeEnum.values()) {
            if (type.getCode().equalsIgnoreCase(code)) {
                return type;
            }
        }
        return null;
    }

    public static boolean isValid(String code) {
        return fromCode(code) != null;
    }
}
