package cn.smarthse.rho.core.framework.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 系统配置
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/6/20 13:55
 */
@Data
@ConfigurationProperties(prefix = "sys")
public class SysProperties {

    /**
     * 大数据日志appcode
     */
    private String bigDataLogAppCode;

    /**
     * 万达推送地址
     */
    private String wandaPullUrl;
    /**
     * 万达接口加签密钥
     */
    private String wandaAppSecret;

    /**
     * 职业健康/在线培训管理对接密匙
     */
    public String healthOnlineTrainingAesKey;
    public String rayCertAesKey;

    /**
     * 在线培训管理地址
     */
    public String healthOnlineTrainingUrl;
    /**
     * 在线培训管理登录后回调地址
     */
    public String healthOnlineTrainingRedirectUrl;

    /**
     * 职业健康在线监管端地址
     */
    public String healthSupUrl;

    /**
     * 证书预览地址QR（重定向/下载）
     */
    private String certQrUrl;
    /**
     * 证书预览地址QR
     */
    private String certQrUrlPreview;

    /**
     * 体检佐证材料化解的有效性日期。
     */
    public LocalDate acceptanceExpiryDate;

    /**
     * 文件上传支持的文件类型
     */
    private List<String> supportFileTypes = Arrays.asList("doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf", "jpg", "jpeg", "png", "txt", "wmv", "mp4", "m4v", "zip", "rar");
    private List<String> supportM3U8FileTypes = Arrays.asList("mp4", "m4v");
    /**
     * 登录配置
     */
    @NestedConfigurationProperty
    private Login login = new Login();

    /**
     * 浙政钉单点登录配置
     */
    @NestedConfigurationProperty
    private Zwdd zwdd = new Zwdd();

    /**
     * 浙政钉扫码登录配置
     */
    @NestedConfigurationProperty
    private ZwddQr zwddQr = new ZwddQr();

    /**
     * 浙里办配置
     */
    @NestedConfigurationProperty
    private Zlb zlb = new Zlb();

    /**
     * 蓝牙定位网关中间件 配置
     */
    @NestedConfigurationProperty
    public RwLinkIf3 rwLinkIf3 = new RwLinkIf3();

    /**
     * 登录配置
     */
    @Data
    public static class Login {
        /**
         * 开启登录双因子校验
         */
        boolean twoFactorCheck = true;

        String multiLoginAccount;
        /**
         * 密码错误重试记录次数 default 5 次（超过设定值，需等X分钟后再试，缓存目前设定10分钟）
         */
        Integer retryCount = 5;
        /**
         * 密码错误锁定时间/min default 10 min
         */
        Integer retryLockTime = 30;

        Long timeout = 60 * 60 * 24L;

        Long activeTimeout = 60 * 30L;
    }

    /**
     * 浙政钉配置
     */
    @Data
    public static class Zwdd {

        private String accessKey;

        private String secretKey;

        private String domainName;

        private String protocal;

        private Long tenantId;
    }

    /**
     * 浙政钉扫码登录配置
     */
    @Data
    public static class ZwddQr {

        private String clientId;

        private String appKey;

        private String appSecret;

        private String loginDomain;

        private String apiDomain;

        private String protocal;

        private String callBackUrl;

        /**
         * 获取扫码地址 iframe嵌入
         */
        public String getQRCodeUrl() {
            return String.format("%s://%s/oauth2/auth.htm?response_type=code&client_id=%s&redirect_uri=%s&scope=get_user_info&authType=QRCODE&embedMode=true", protocal, loginDomain, clientId, callBackUrl);
            // protocal + "://" + loginDomain + "/oauth2/auth.htm?response_type=code&client_id="+clientId+"&redirect_uri="+callBackUrl+"&scope=get_user_info&authType=QRCODE";
        }
    }

    /**
     * 浙里办配置
     */
    @Data
    public static class Zlb {

        private String appKey;
        private String appSecret;
        private String appId;
        private String host = "https://bcdsg.zj.gov.cn:8443"; // 政务网 https://bcdsg.zj.gov.cn:8443 互联网：https://ibcdsg.zj.gov.cn:8443
    }

    /**
     * 蓝牙定位引擎
     */
    @Data
    public static class RwLinkIf3 {
        private String syncPositionDataUrl;
        private String syncGatewayDataUrl;
    }
}
