package cn.smarthse.rho.core.framework.bootstrap.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties("alipay-config")
@Data
public class AlipayProperties {
	
	/**
     * 通信协议，通常填写https
     */
    public String protocol;

    /**
     * 网关域名
     * 线上为：openapi.alipay.com
     * 沙箱为：openapi.alipaydev.com
     */
    public String gatewayHost;

    /**
     * AppId
     */
    public String appId;

    /**
     * 签名类型，Alipay Easy SDK只推荐使用RSA2，估此处固定填写RSA2
     */
    public String signType;

    /**
     * 支付宝公钥
     */
    public String alipayPublicKey;

    /**
     * 应用私钥
     */
    public String merchantPrivateKey;

    /**
     * 应用公钥证书文件路径
     */
    public String merchantCertPath;

    /**
     * 支付宝公钥证书文件路径
     */
    public String alipayCertPath;

    /**
     * 支付宝根证书文件路径
     */
    public String alipayRootCertPath;

    /**
     * 异步通知回调地址（可选）
     */
    public String notifyUrl;

    /**
     * AES密钥（可选）
     */
    public String encryptKey;

    /**
     * 签名提供方的名称(可选)，例：Aliyun KMS签名，signProvider = "AliyunKMS"
     */
    public String signProvider;

    /**
     * 代理地址（可选）
     * 例如：http://127.0.0.1:8080
     */
    public String httpProxy;
    
    /**
     * 忽略证书校验（可选）
     */
    public boolean ignoreSSL;
}
