package cn.smarthse.rho.core.framework.annotation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 日志操作类型 1-登录日志 2-操作日志 20-添加类型 21-修改类型
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年7月26日 下午2:25:00
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LogTypeEnum {

    /**
     * 1-密码登录
     */
    type_login("密码登录", 1),
    /**
     * 11-单点登录
     */
    type_cas_login("单点登录", 11),
    /**
     * 12-扫码登录
     */
    type_scan_login("扫码登录", 12),
    /**
     * 13-手机验证码登录
     */
    type_mobile_login("手机验证码登录", 13),
    /**
     * 2-操作日志
     */
    type_opt("操作日志", 2),
    /**
     * 20-添加
     */
    type_opt_add("添加", 20),
    /**
     * 21-修改
     */
    type_opt_edit("修改", 21),
    /**
     * 22-删除
     */
    type_opt_del("删除", 22),
    /**
     * 23-导入
     */
    type_opt_import("导入", 23),
    /**
     * 24-导出
     */
    type_opt_export("导出", 24),
    /**
     * 25-下载
     */
    type_opt_download("下载", 25),
    /**
     * 26-上传
     */
    type_opt_upload("上传", 26),
    /**
     * 27-重置密码
     */
    type_opt_reset("重置密码", 27),
    /**
     * 28-初始化
     */
    type_opt_init("初始化", 28),
    /**
     * 29-修改密码
     */
    type_opt_changePass("修改密码", 29),
    /**
     * 30-敏感信息查看
     */
    type_opt_ac_info("敏感信息查看", 30),

    anon("其他", 0),
    ;

    /**
     * 日志类型
     */
    public final String name;
    /**
     * 日志类型编码
     */
    public final Integer value;

    LogTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static LogTypeEnum getByVlaue(Integer value) {
        for (LogTypeEnum c : LogTypeEnum.values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return LogTypeEnum.anon;
    }

    public static String getNameByVlaue(Integer value) {

        return getByVlaue(value).getName();
    }

}
