package cn.smarthse.rho.core.framework.annotation;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 日志来源（单位-1；机构端-2；监管-3）
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/4年9:27月日
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum LogResourceEnum {

    /**
     * 医院端-1
     */
    company("company", 1, "医院端"),

    /**
     * 机构端-2
     */
    org("org", 2, "机构端"),

    /**
     * 监管端-3
     */
    supervise("supervise", 3, "监管端"),

    anon("-", 0, "其他"),
    ;

    /**
     * 日志来源编码
     */
    public final String code;
    /**
     * 日志来源编码
     */
    public final Integer value;
    /**
     * 日志来源
     */
    public final String name;

    LogResourceEnum(String code, Integer value, String name) {
        this.code = code;
        this.value = value;
        this.name = name;
    }

    public static LogResourceEnum getByValue(Integer value) {
        for (LogResourceEnum c : LogResourceEnum.values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return LogResourceEnum.anon;
    }

    public static String getLogResourceName(Integer value) {

        return getByValue(value).getName();
    }

}
