package cn.smarthse.rho.core.framework;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.error.SaErrorCode;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaTokenConsts;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

@Slf4j
public class ShiroCommonUtil {

    public static final String USERTYPE_SUPERVISE_KEY = "supervise";
    public static final String USERTYPE_COMPANY_KEY = "company";

    public static final String LOGIN_USER_KEY = "loginUser";
    public static final String USER_TYPE_KEY = "userType";
    public static final String LOGIN_METHOD_KEY = "loginMethod";
    public static final String USERID_KEY = "userId";
    public static final String USERNAME_KEY = "username";
    public static final String FULL_NAME_KEY = "fullName";
    public static final String OID_CID_KEY = "oidOrCid";
    public static final String AREA_ID_KEY = "areaId";
    public static final String AREA_LEVEL_KEY = "areaLevel";
    public static final String IS_TEST_KEY = "isTest";

    public static String getRandomString() {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; i++) {
            int number = ThreadLocalRandom.current().nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static void login(LoginUser loginUser, SaLoginParameter model) {
        model = ObjectUtil.defaultIfNull(model, new SaLoginParameter());
        StpUtil.login(loginUser.getLoginId(), model
                .setIsConcurrent(isMultiLoginAccount(loginUser.getUsername()))
                .setExtra(USER_TYPE_KEY, loginUser.getUserType())
                .setExtra(LOGIN_METHOD_KEY, loginUser.getLoginMethod())
                .setExtra(USERID_KEY, loginUser.getId())
                .setExtra(USERNAME_KEY, loginUser.getUsername())
                .setExtra(FULL_NAME_KEY, loginUser.getFullName())
                .setExtra(OID_CID_KEY, loginUser.getOidOrcid())
                .setExtra(AREA_ID_KEY, loginUser.getAreaId())
                .setExtra(AREA_LEVEL_KEY, loginUser.getAreaLevel())
                .setExtra(IS_TEST_KEY, loginUser.getIsTest())
        );
        StpUtil.getTokenSession().set(LOGIN_USER_KEY, loginUser);
    }

    public static <T extends LoginUser> T getShiroPrincipal() {
        SaSession session = StpUtil.getTokenSession();
        if (ObjectUtil.isNull(session)) {
            return null;
        }
        return (T) session.get(LOGIN_USER_KEY);
    }

    public static <T extends LoginUser> T getShiroPrincipal(String token) {
        if (SaFoxUtil.isEmpty(token)) {
            return null;
        }
        String tokenPrefix = SaManager.getConfig().getTokenPrefix();
        if (SaFoxUtil.isNotEmpty(tokenPrefix)) {
            if (!token.startsWith(tokenPrefix + SaTokenConsts.TOKEN_CONNECTOR_CHAT)) {
                throw NotLoginException.newInstance(StpUtil.stpLogic.loginType, NotLoginException.NO_PREFIX, NotLoginException.NO_PREFIX_MESSAGE + "，prefix=" + tokenPrefix, null).setCode(SaErrorCode.CODE_11017);
            } else {
                token = token.substring(tokenPrefix.length() + SaTokenConsts.TOKEN_CONNECTOR_CHAT.length());
            }
        }

        SaSession session = StpUtil.getTokenSessionByToken(token);
        if (ObjectUtil.isNull(session)) {
            return null;
        }
        return (T) session.get(LOGIN_USER_KEY);
    }

    public static Object getLoginId(String userType, Long userId) {
        if (userType == null) {
            throw new IllegalArgumentException("用户类型不能为空");
        }
        if (userId == null) {
            throw new IllegalArgumentException("用户ID不能为空");
        }
        return userType + ":" + userId;
    }

    private static Object getExtra(String key) {
        try {
            return StpUtil.getExtra(key);
        } catch (ApiDisabledException e) {
            log.error("获取JWT信息失败", e);
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static Long getJWTUserType() {
        return Convert.toLong(getExtra(USER_TYPE_KEY));
    }

    public static Long getJWTLoginMethod() {
        return Convert.toLong(getExtra(LOGIN_METHOD_KEY));
    }

    public static Long getJWTUserId() {
        return Convert.toLong(getExtra(USERID_KEY));
    }

    public static String getJWTUsername() {
        return Convert.toStr(getExtra(USERNAME_KEY));
    }

    public static String getJWTFullName() {
        return Convert.toStr(getExtra(FULL_NAME_KEY));
    }

    public static Long getJWTOidOrCid() {
        return Convert.toLong(getExtra(OID_CID_KEY));
    }

    public static Long getJWTAreaId() {
        return Convert.toLong(getExtra(AREA_ID_KEY));
    }

    public static Byte getJWTAreaLevel() {
        return Convert.toByte(getExtra(AREA_LEVEL_KEY));
    }

    public static Integer getJWTIsTest() {
        return Convert.toInt(getExtra(IS_TEST_KEY));
    }

    public static boolean isMultiLoginAccount(String username) {
        if (StringUtils.isEmpty(username)) {
            return SaManager.getConfig().getIsConcurrent();
        }
        String specifiedUserName = SpringUtils.getBean(SysProperties.class).getLogin().getMultiLoginAccount();
        if (StringUtils.isEmpty(specifiedUserName)) {
            return SaManager.getConfig().getIsConcurrent();
        }
        String upperUsername = username.toUpperCase();
        String upperSpecifiedUserName = specifiedUserName.toUpperCase();
        String[] unameArr = upperSpecifiedUserName.split(",");
        return Arrays.asList(unameArr).contains(upperUsername);
    }

}
