package cn.smarthse.rho.core.framework;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@Data
@NoArgsConstructor
public class LoginUser implements Serializable {

    //@ApiModelProperty("账号id")
    private Long id;
    //@ApiModelProperty("账号")
    private String username;
    //@ApiModelProperty("用户姓名")
    private String fullName;
    private Long oidOrcid;
    //@ApiModelProperty("行政区划id")
    private Long areaId;
    //@ApiModelProperty("行政区划Level")
    private Byte areaLevel;
    //@ApiModelProperty("是否是测试（0-否，1-是）")
    private Integer isTest;

    /**
     * 用户类型
     */
    private String userType;
    /**
     * 登录方式
     */
    private Integer loginMethod;

    /**
     * 角色列表
     */
    private Set<String> roleSet = new HashSet<>();

    /**
     * 权限列表
     */
    private Set<String> permissionsSet = new HashSet<>();

    public Map<String, Object> extraData = new LinkedHashMap<>();

    public LoginUser setExtra(String key, Object value) {
        this.extraData.put(key, value);
        return this;
    }

    public LoginUser setExtras(Map<String, Object> extras) {
        if (extras != null && !extras.isEmpty()) {
            this.extraData.putAll(extras);
        }
        return this;
    }

    @JsonIgnore
    public Object getLoginId() {
        if (userType == null) {
            throw new IllegalArgumentException("用户类型不能为空");
        }
        if (id == null) {
            throw new IllegalArgumentException("用户ID不能为空");
        }
        return userType + ":" + id;
    }

}
